function parseLoggerAction(json) {
    var method = json.Method;

    switch (method) {
        case 'LogEntry':
            return new LogEntry();

        case 'LogProfile':
            return new LogProfile();

        default:
            throw new Error('Unknown Logger Method: ' + JSON.stringify(json, null, 2));
    }
}



class LoggerAction extends Action {
    constructor() {
        super();
        this.Type = 'Logger';
        this.Method = 'void';
        this.Params = {};
    }
}



class LogEntry extends LoggerAction {
    constructor(filename, text) {
        super();
        this.Method = 'LogEntry';
        this.Params.Filename = filename;
        this.Params.Text = text;
    }

    editTemplate() {
        var template = 'Log ' +
            '<input name="' + guid() + '" required class="form-control" type="text" ng-model="action.Params.Text" data-toggle="tooltip" title="Text to be logged" style="width:500px;"> ' +
            'to <input name="' + guid() + '" required class="form-control" type="text" ng-model="action.Params.FileName" data-toggle="tooltip" title="Filename">';
        return template;
    }
}



class LogProfile extends LoggerAction {
    constructor(profileName) {
        super();
        this.Method = 'LogProfile';
        this.Params.ProfileName = profileName;
    }

    editTemplate() {
        var template = 'Force Log Profile entry for <input name="' + guid() + '" required class="form-control" type="text" ng-model="action.Params.ProfileName">';
        return template;
    }
}