/*
 * Decompiled with CFR 0.152.
 */
package com.integ.scripting.objects;

import com.integ.scripting.ExpressionEngine;
import com.integ.scripting.exceptions.ScriptParserException;
import com.integ.scripting.exceptions.UnexpectedTokenException;
import com.integ.scripting.nodes.AbstractNode;
import com.integ.scripting.objects.AbstractObjectCall;
import com.integ.tasker.tasks.Scope;
import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.janoslib.utils.DateUtils;
import java.util.Calendar;

public class DateObject
extends AbstractObjectCall {
    @Override
    public AbstractNode parse(ExpressionEngine parser) throws ScriptParserException {
        try {
            if (parser.peekToken().checkType(46)) {
                parser.nextToken();
                if (!parser.nextToken().checkType(0)) {
                    throw new UnexpectedTokenException("FIELD OR METHOD NAME", parser.currentToken());
                }
                switch (this._fieldOrMethodName = parser.currentToken().content) {
                    case "format": {
                        this.parseArguments(parser);
                        break;
                    }
                    case "isDay": {
                        this.parseArguments(parser);
                        break;
                    }
                    case "currentmillis": {
                        this.parseArguments(parser);
                    }
                }
            } else {
                this._fieldOrMethodName = "format";
                this.parseArguments(parser);
            }
        }
        catch (Exception ex) {
            throw new ScriptParserException("unable to process date", ex);
        }
        return this;
    }

    @Override
    public Object execute(Scope scope) {
        boolean _debug_ = scope.isDebug();
        if ("format".equalsIgnoreCase(this._fieldOrMethodName)) {
            String formatString = ((AbstractNode)this._arguments.get(0)).toString();
            if (_debug_) {
                System.out.println("   formatString = " + formatString);
            }
            QuickDateFormat dateFormat = new QuickDateFormat(formatString);
            if (_debug_) {
                System.out.println("   dateformat = " + dateFormat.format());
            }
            return dateFormat.format();
        }
        if ("isDay".equalsIgnoreCase(this._fieldOrMethodName)) {
            boolean isDayValid;
            Calendar cal = Calendar.getInstance();
            int dayOfWeek = cal.get(7);
            String dayAbbrv = DateUtils.DAYS_OF_WEEK_ABBRV_ARRAY[dayOfWeek - 1];
            dayAbbrv = dayAbbrv.toLowerCase();
            String parameterString = ((AbstractNode)this._arguments.get(0)).toString().toLowerCase();
            int index = parameterString.indexOf(dayAbbrv);
            boolean bl = isDayValid = -1 != index;
            if (_debug_) {
                System.out.println("dayAbbrv: " + dayAbbrv + " = _parametersString: " + ((AbstractNode)this._arguments.get(0)).toString() + ", index: " + index + " = " + isDayValid);
            }
            return isDayValid;
        }
        if ("currentmillis".equalsIgnoreCase(this._fieldOrMethodName)) {
            return System.currentTimeMillis();
        }
        return null;
    }
}

