/*
 * Decompiled with CFR 0.152.
 */
package com.integ.common.logging;

import com.integ.common.logging.AppLog;
import java.io.PrintStream;

public abstract class Logger {
    protected PrintStream _printStream;
    protected boolean _finalized = false;
    protected long _nextFlushTime = Long.MAX_VALUE;

    public long getNextFlushTime() {
        return this._nextFlushTime;
    }

    protected void setPrintStream(PrintStream printStream) {
        this._printStream = printStream;
    }

    public PrintStream getPrintStream() {
        return this._printStream;
    }

    public Logger setMaxSizeKB(int maxSizeKB) {
        return this;
    }

    public void vital(String vitalString) {
        this.println(String.format("## %s", vitalString));
    }

    public void info(String infoString) {
        this.println(infoString);
    }

    public void debug(String debugString) {
        this.println(String.format("?? %s", debugString));
    }

    public void warn(String warningString) {
        this.println(String.format(" * %s", warningString));
    }

    public void error(String errorString, Throwable ex) {
        if (null != ex) {
            String exceptionMessage = ex.getMessage();
            if (null == exceptionMessage) {
                exceptionMessage = ex.getClass().getName();
            }
            this.println(String.format("** %s: %s", errorString, exceptionMessage));
            AppLog.error(errorString, ex);
        } else {
            this.error(errorString);
        }
    }

    public void error(String errorString) {
        if (null != errorString) {
            this.println(String.format("** %s", errorString));
        }
    }

    public void error(Throwable ex) {
        this.println(String.format("** %s", ex.getMessage()));
        AppLog.error(ex);
    }

    public void fatal(String fatalString) {
        this.println(String.format("*** %s", fatalString));
    }

    protected synchronized void println(String s) {
        this._printStream.println(s);
    }

    protected synchronized void print(String s) {
        this._printStream.print(s);
    }

    public synchronized void writeln(String s) {
        this._printStream.print(s);
    }

    protected abstract void flush();
}

