/*
 * Decompiled with CFR 0.152.
 */
package com.integ.common.net;

import com.integ.common.logging.Logger;
import com.integ.common.logging.SystemOutLog;
import com.integ.common.net.TcpServerEvent;
import com.integ.common.net.TcpServerListener;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class TcpServer
implements Runnable {
    private Logger _log = SystemOutLog.getLogger();
    private final String _name;
    private TcpServerListener _listener = null;
    private ServerSocket svrSocket;
    private Socket socket;
    private final int _port;
    private Thread _thread;
    private boolean bServerRun = true;

    public TcpServer(String name, int port) {
        this._name = name;
        this._port = port;
    }

    public void setLog(Logger log) {
        this._log = log;
    }

    public void setTcpServerListener(TcpServerListener listener) {
        this._listener = listener;
    }

    public void start() {
        try {
            this._log.info("Start server for " + this._name + " clients on port " + this._port + ".");
            this.svrSocket = new ServerSocket(this._port);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to start the server: " + ex.getMessage());
        }
        try {
            this._thread = new Thread(this);
            this._thread.setName(this.getClass().getName() + ":" + this._port);
            this._thread.setDaemon(true);
            this._thread.start();
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Unable to start the server: " + ex.getMessage());
        }
    }

    public void stop() throws IOException {
        this.bServerRun = false;
        this.svrSocket.close();
        try {
            this._thread.interrupt();
            this._thread.join();
        }
        catch (InterruptedException ex) {
            this._log.error("Error stopping server socket: " + ex.getMessage());
        }
    }

    @Override
    public void run() {
        try {
            this._log.info("Listening for " + this._name + " clients on port " + this._port + ".");
            while (this.bServerRun) {
                try {
                    this.socket = this.svrSocket.accept();
                    if (this._listener == null) continue;
                    this._listener.clientConnected(new TcpServerEvent(this, this.socket));
                }
                catch (IOException ex) {
                    this._log.error("Error accepting server socket connection: " + ex.getMessage());
                    this.bServerRun = false;
                }
                catch (Exception ex) {
                    this._log.error("Error accepting server socket connection: " + ex.getMessage());
                }
            }
        }
        catch (Exception ex) {
            this._log.error("Error accepting server socket connection: " + ex.getMessage());
            this.bServerRun = false;
        }
        try {
            this.svrSocket.close();
        }
        catch (IOException ex) {
            this._log.error("Error closing server socket: " + ex.getMessage());
        }
        this.svrSocket = null;
    }
}

