function parseAnalogControlAction(json) {
    var method = json.Method;

    switch (method) {
        case 'Set10vPercent':
            return new Set10vPercent();

        case 'Set10vVoltage':
            return new Set10vVoltage();

        case 'Set420maPercent':
            return new Set420maPercent();

        case 'Set420maAmps':
            return new Set420maAmps();

        default:
            throw new Error('Unknown Analog Control Method: ' + JSON.stringify(json, null, 2));
    }
}



class AnalogControlAction extends Action {
    constructor() {
        super();
        this.Type = 'AnalogControl';
        this.Method = 'void';
        this.Params = {};
    }
}



class Set10vPercent extends AnalogControlAction {
    constructor(channel, percent) {
        super();
        this.Method = 'Set10vPercent';
        this.Params.Channel = channel;
        this.Params.Percent = percent;
    }

    editTemplate() {
        var template = 'Set 10v Output Channel <input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.Channel" data-toggle="tooltip" title="10v Output Channel"> ' +
            'to <input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.Percent" data-toggle="tooltip" title="Percentage 0 - 100%">';
        return template;
    }
}



class Set10vVoltage extends AnalogControlAction {
    constructor(channel, voltage) {
        super();
        this.Method = 'Set10vVoltage';
        this.Params.Channel = channel;
        this.Params.Voltage = voltage;
    }

    editTemplate() {
        var template = 'Set 10v Output Channel Voltage <input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.Channel" data-toggle="tooltip" title="10v Output Channel"> ' +
            'to <input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.Voltage" data-toggle="tooltip" title="Voltage (0 - 10v)">';
        return template;
    }
}



class Set420maPercent extends AnalogControlAction {
    constructor(channel, percent) {
        super();
        this.Method = 'Set420maPercent';
        this.Params.Channel = channel;
        this.Params.Percent = percent;
    }

    editTemplate() {
        var template = 'Set 4-20ma Output Channel Percentage <input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.Channel" data-toggle="tooltip" title="4-20ma Output Channel"> ' +
            'to <input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.Percent" data-toggle="tooltip" title="Percentage 0 - 100%">';
        return template;
    }
}



class Set420maAmps extends AnalogControlAction {
    constructor(channel, amps) {
        super();
        this.Method = 'Set420maAmps';
        this.Params.Channel = channel;
        this.Params.Amps = amps;
    }

    editTemplate() {
        var template = 'Set 4-20ma Output Channel Amps <input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.Channel" data-toggle="tooltip" title="4-20ma Output Channel"> ' +
            'to <input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.Amps" data-toggle="tooltip" title="Amps (4 - 20ma)">';
        return template;
    }
}