/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.system;

import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.system.Application;
import com.integpg.janoslib.system.MinimumVersion;
import com.integpg.system.Watchdog;

public class ApplicationWatchdog
implements Runnable {
    private static final boolean REQUIRED_OS_VERSION = MinimumVersion.atLeast("ApplicationWatchdog", "1.3-b10.3");
    private Watchdog _watchdog = null;
    private Thread _thd;

    public ApplicationWatchdog(int watchdogAction) {
        if (REQUIRED_OS_VERSION) {
            this._watchdog = new Watchdog(Application.getAppInstanceName());
            this._watchdog.setAction(watchdogAction);
        }
    }

    public void start() {
        if (null != this._watchdog && null == this._thd) {
            this._thd = new Thread(this);
            this._thd.setName(Application.getAppName() + "Watchdog");
            this._thd.setDaemon(true);
            this._thd.start();
        }
    }

    @Override
    public void run() {
        AppLog.vital("Activate " + this._watchdog.getText() + " watchdog");
        this._watchdog.activate(120000);
        try {
            while (true) {
                this._watchdog.refresh();
                Thread.sleep(60000L);
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace(System.err);
            return;
        }
    }
}

