/*
 * Decompiled with CFR 0.152.
 */
package com.integ.common.net;

import com.integ.common.logging.Logger;
import com.integ.common.logging.SystemOutLog;
import com.integ.common.net.BytesReceivedEvent;
import com.integ.common.net.ClientListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.EventObject;

public class AsciiCommandClient
implements Runnable {
    private Logger _log = SystemOutLog.getLogger();
    private final String _clientNameString;
    private final InputStream _inputStream;
    private final StringBuffer _stringBuffer = new StringBuffer();
    private Thread _thread = null;
    private String _terminationString = "\n";
    private ClientListener _listener;

    public AsciiCommandClient(String clientNameString, InputStream inputStream) {
        this._clientNameString = clientNameString;
        this._inputStream = inputStream;
    }

    public void setLog(Logger log) {
        this._log = log;
    }

    public void setTerminationBytes(String terminationString) {
        this._terminationString = terminationString;
    }

    public void setClientListener(ClientListener listener) {
        this._listener = listener;
    }

    public void start() {
        if (null == this._thread) {
            this._thread = new Thread(this);
            this._thread.setName(this.getClass().getName());
            this._thread.setDaemon(true);
            this._thread.start();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        byte[] buffer = new byte[1024];
        if (null != this._listener) {
            this._listener.clientStarted(new EventObject(this));
        }
        try {
            block8: while (true) {
                int bytesRead;
                if (-1 == (bytesRead = this._inputStream.read(buffer))) {
                    throw new IOException();
                }
                try {
                    String asciiData = new String(buffer, 0, bytesRead);
                    this._stringBuffer.append(asciiData);
                    int semicolonPos = -1;
                    while (true) {
                        if (-1 == (semicolonPos = this._stringBuffer.indexOf(this._terminationString))) continue block8;
                        String message = this._stringBuffer.substring(0, semicolonPos);
                        this._stringBuffer.delete(0, semicolonPos + 1);
                        try {
                            if (null != this._listener) {
                                this._listener.bytesReceived(new BytesReceivedEvent(this, message.getBytes(), 0, message.length()));
                                continue;
                            }
                            this._log.info(this._clientNameString + " received: " + message);
                        }
                        catch (Exception ex) {
                            this._log.error(this._clientNameString + " error processing read bytes", ex);
                        }
                    }
                }
                catch (Exception ex) {
                    this._log.error(this._clientNameString + " error processing read bytes", ex);
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            try {
                this._inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._log.error(this._clientNameString + " client closing", ex);
            if (null != this._listener) {
                this._listener.clientFinished(new EventObject(this));
            }
            return;
        }
    }
}

