/*
 * Decompiled with CFR 0.152.
 */
package com.integ.common.iolog;

import com.integ.common.iolog.DigitalInputsIoLogMonitor;
import com.integ.common.iolog.IoChannelLogListener;
import com.integ.common.iolog.IoLogListener;
import com.integ.common.iolog.RelayOutputsIoLogMonitor;
import com.integ.common.logging.Logger;
import com.integ.common.logging.SystemOutLog;
import com.integpg.system.IoEvent;
import com.integpg.system.Iolog;
import com.integpg.system.JANOS;
import java.text.QuickDateFormat;
import java.util.ArrayList;

public abstract class IoLogMonitor
implements Runnable {
    protected static final QuickDateFormat QUICK_DATE_FORMAT = new QuickDateFormat("MM/dd/yyyy HH:mm:ss.fff");
    protected final Iolog _iolog = new Iolog();
    protected final ArrayList<IoLogListener> _ioLogEventListeners = new ArrayList();
    protected final ArrayList<IoChannelLogListener> _ioChannelLogEventListeners = new ArrayList();
    protected Logger LOG = SystemOutLog.getLogger();
    private Thread _thd;
    private long _refreshTimestamp;
    protected static IoEvent _lastIoEvent;
    protected static IoEvent _lastInputEvent;
    protected static IoEvent _lastOutputEvent;

    protected IoLogMonitor() {
    }

    public void start() {
        if (null == this._thd) {
            this._thd = new Thread(this);
            this._thd.setName(this.getClass().getName());
            this._thd.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIoLogEventListener(IoLogListener ioLogEventListener) {
        ArrayList<IoLogListener> arrayList = this._ioLogEventListeners;
        synchronized (arrayList) {
            this._ioLogEventListeners.add(ioLogEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIoLogEventListener(IoLogListener ioLogEventListener) {
        ArrayList<IoLogListener> arrayList = this._ioLogEventListeners;
        synchronized (arrayList) {
            this._ioLogEventListeners.remove(ioLogEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIoChannelLogEventListener(IoChannelLogListener digitalOutputsLogListener) {
        ArrayList<IoChannelLogListener> arrayList = this._ioChannelLogEventListeners;
        synchronized (arrayList) {
            this._ioChannelLogEventListeners.add(digitalOutputsLogListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIoChannelLogEventListener(IoChannelLogListener digitalOutputsLogListener) {
        ArrayList<IoChannelLogListener> arrayList = this._ioChannelLogEventListeners;
        synchronized (arrayList) {
            this._ioChannelLogEventListeners.remove(digitalOutputsLogListener);
        }
    }

    public void setRefreshTimestamp(long refreshTimestamp) {
        this._refreshTimestamp = refreshTimestamp;
    }

    protected abstract IoEvent[] getIoEvents();

    public static IoEvent getLastIoEvent() {
        return _lastIoEvent;
    }

    public static IoEvent getLastInputEvent() {
        return _lastInputEvent;
    }

    public static IoEvent getLastOutputEvent() {
        return _lastOutputEvent;
    }

    @Override
    public void run() {
        long _savedSignature = -1L;
        while (true) {
            try {
                while (true) {
                    long signature;
                    if (_savedSignature != (signature = JANOS.getIoSignature())) {
                        _savedSignature = signature;
                        this._iolog.refresh(this._refreshTimestamp);
                        IoEvent[] ioEvents = this.getIoEvents();
                        if (ioEvents.length > 0) {
                            if (1 < ioEvents.length) {
                                this.LOG.info(ioEvents.length + " events returned since " + QUICK_DATE_FORMAT.format(this._refreshTimestamp));
                            }
                            int errorCount = 0;
                            for (int index = ioEvents.length - 1; index >= 0; --index) {
                                IoEvent ioEvent = ioEvents[index];
                                if (ioEvent.timestamp < this._refreshTimestamp) {
                                    ++errorCount;
                                    continue;
                                }
                                this.alertListenersOfIoEvent(ioEvent);
                            }
                            if (0 != errorCount) {
                                this.LOG.info("iolog returned " + errorCount + " events earlier than the requested time of " + QUICK_DATE_FORMAT.format(this._refreshTimestamp));
                            }
                            this._refreshTimestamp = ioEvents[0].timestamp;
                            this.alertListenersOfEventsProcessed();
                        }
                    }
                    Thread.sleep(10L);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alertListenersOfIoEvent(IoEvent ioEvent) {
        try {
            long start = System.currentTimeMillis();
            if (null == _lastIoEvent || IoLogMonitor._lastIoEvent.timestamp < ioEvent.timestamp) {
                _lastIoEvent = ioEvent;
            }
            if (this instanceof DigitalInputsIoLogMonitor) {
                _lastInputEvent = ioEvent;
            } else if (this instanceof RelayOutputsIoLogMonitor) {
                _lastOutputEvent = ioEvent;
            }
            ArrayList<IoLogListener> arrayList = this._ioLogEventListeners;
            synchronized (arrayList) {
                for (IoLogListener ioLogListener : this._ioLogEventListeners) {
                    if (null == ioLogListener) continue;
                    ioLogListener.onIoEvent(ioEvent);
                }
            }
            long elapsed = System.currentTimeMillis() - start;
            if (100L < elapsed) {
                System.out.println(String.format("process event took %.3f", (double)elapsed / 1000.0));
            }
            this.alertIoChannelListeners(ioEvent);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public abstract void alertIoChannelListeners(IoEvent var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alertListenersOfEventsProcessed() {
        try {
            ArrayList<IoLogListener> arrayList = this._ioLogEventListeners;
            synchronized (arrayList) {
                for (IoLogListener ioLogListener : this._ioLogEventListeners) {
                    if (null == ioLogListener) continue;
                    long start = System.currentTimeMillis();
                    ioLogListener.onIoEventsProcessed();
                    long elapsed = System.currentTimeMillis() - start;
                    if (100L >= elapsed) continue;
                    System.out.println(String.format("process event took %.3f", (double)elapsed / 1000.0));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

