/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.schedules.rules;

import com.integ.tasker.schedules.rules.DateRuleBase;
import com.integpg.janoslib.utils.DateUtils;
import java.util.Calendar;
import java.util.Json;

public class WeeklyDateRule
extends DateRuleBase {
    public WeeklyDateRule(Json dateOptionsJson) {
        super(dateOptionsJson);
        Json daysJson = (Json)dateOptionsJson.get("Days");
        String[] daysOfWeek = DateUtils.DAYS_OF_WEEK_ARRAY;
        boolean atLeastOneDay = false;
        for (int i = 0; i < 7; ++i) {
            String dayOfWeek = daysOfWeek[i];
            this._daysEnabled[i] = daysJson.getBoolean(dayOfWeek);
            atLeastOneDay |= this._daysEnabled[i];
            System.out.println(dayOfWeek + ": " + this._daysEnabled[i]);
        }
        if (!atLeastOneDay) {
            throw new RuntimeException("A weekly schedule must have atleast one day enabled");
        }
    }

    @Override
    public long getNextValidDayStart(long time) {
        long startOfDay = time;
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(startOfDay);
        for (int i = 0; i < 7; ++i) {
            int dayOfWeek = cal.get(7);
            System.out.println("dayOfWeek: " + dayOfWeek);
            if (this._daysEnabled[dayOfWeek - 1]) {
                return cal.getTime().getTime();
            }
            cal.setTimeInMillis(startOfDay += 86400000L);
        }
        return Long.MIN_VALUE;
    }
}

