 /*
  JNIOR Monitor/Configuration Page
  INTEG Process Group, Inc., 2919 E Hardies Rd, Gibsonia PA 
  724.933.9350
  
  File: modules.js
  
  The user is hereby granted license to use, modify, and redistribute the contents of this
  file for any purpose, commercial or otherwise. No prior authorization by INTEG Process 
  Group, Inc. is required.
*/ 

// expanded module for configuration
var config_module = null;

// executed each second to poll external devices
function poll() {
	
	if (!chan.open)
		return false;
	
	// pace polling if we are not displaying the external modules
	poll_pacer++;
	if (document.getElementById("control").className == "tabbed hide" && (poll_pacer % 10) != 0)
		return;
	if (document.getElementById("external").className == "iosettings hide" && (poll_pacer % 10) != 0)
		return;
	poll_pacer = 0;
	
	// poll only if we have devices
	if (module_idToStatus.length == 0)
		return;
		
	// determine if there are devices that require polling
	var devices = new Array();
	var n = 0;
	for (id in module_idToStatus) {

		// skip those not active
		var status = module_idToStatus[id];
		if (status == null || status == "")
			continue;
		
		// skip those covered in relay grouping
		var key = module_idToKey[id];
		if (key.endsWith("fb_1"))
			continue;
		if (jnior_model != 412 && key.endsWith("fb_2")) 
			continue;
		if (jnior_model == 414 && key.endsWith("fb_3"))
			continue;
			
		devices[n++] = id;
	}
	
	if (devices.length) {
		var request = new Object();
		request['Message'] = "Read Devices";
		request['Devices'] = devices;
		chan.sendJson(request);
	}
}
// **************************************************
//	E X T E R N A L   M O D U L E   R O U T I N E S

// Function creates the HTML for the 'Modules' configuration page. Called when module
//  conditions change. This then calls the function to create the External Input/Output page.
function update_modulelist() {
	
	// generates HTML for the External Modules table
	var etable = document.getElementById('modulelist');
	var inner = "<tr><th>Module</th><th>Serial No.</th><th>ID</th><th>Status</th><th>Assignment</th></tr>";
	
	// Obtain keys for sorting
	var keys = new Array();
	var n = 0;
	var id;
	for (id in module_idToKey) {
		var key = module_idToKey[id];
		keys[n++] = key;
	}
	keys.sort();
		
	// Build table in key sorted order
	var reqn = 0;
	for (n = 0; n < keys.length; n++) {
		var key = keys[n];
		var id = module_keyToId[key];
		if (id === undefined)
			continue;
			
		var serno = id.substring(4, 14);
		var type = id.substring(id.length - 2);
		
		var state;
		var color;
		if (module_present.indexOf(id) == -1) {
			state = "not found";
			color = "class='notfound'";
		}
		else {
			state = "connected";
			color = "";
		}
		
		var dfltname;
		if (type == "F9")
			dfltname = "LED Dimmer";
		else if (type == "FA")
			dfltname = "Control Panel";
		else if (type == "FB")
			dfltname = "Digital 4ROUT";
		else if (type == "FC")
			dfltname = "Temperature RTD";
		else if (type == "FD")
			dfltname = "Analog 10V";
		else if (type == "FE")
			dfltname = "Analog 4-20ma";
		else if (type == "28" || type == "10") {
			dfltname = "Temperature Sensor";
			serno = "";
		}
		else {
			dfltname = "Unknown Device";
			serno = "";
		}
		
		var action = "";
		if (type == "FB")
			action = " onclick='routAssign(\"" + key + "\", \"" + id + "\")'";
		
		var assign = "";
		if (key.endsWith("typefb_1"))
			assign = "ROUT " + (jnior_outputs + 1) + "-" + (jnior_outputs + 4);
		else if (key.endsWith("typefb_2"))
			assign = "ROUT " + (jnior_outputs + 5) + "-" + (jnior_outputs + 8);
		else if (key.endsWith("typefb_3"))
			assign = "ROUT " + (jnior_outputs + 9) + "-" + (jnior_outputs + 12);

		// Display editable Module Description
		var modkey = "Externals/" + id + "/";
		var dkey = modkey + "Desc";		
		var dkeylower = keystd(dkey);

		inner += "<tr " + color + ">";
		if (config_module == id)
			inner += "<td class='clickable' onclick='modexpand(null);return false;'>" +
					"<img src='expanded.png' width='10' height='10' />";
		else
			inner += "<td class='clickable' onclick='modexpand(\"" + id + "\");return false;'>" +
					"<img src='collapsed.png' width='10' height='10' />";
		inner += "<span name='" + dkeylower + "'>" + getkey(dkey, dfltname) + "</span></td>";
		
		inner += "<td>" + serno + 
			"</td><td>" + id + "</td><td nowrap>" + state + 
			"</td><td class='clickable' nowrap" + action + ">" + assign + "</td></tr>";
	}
	
	etable.innerHTML = inner;
}

// Function creates the HTML for a module's configuration. Called when module configuration
//	is selected.
function module_conf() {
	var id = config_module;
	var conf = document.getElementById("modconfig");

	// remove configuration if cleared
	if (id == null) {
		conf.innerHTML = "";
	}
	else {		
		var type = id.substring(id.length - 2);
		var dfltname = "LED Dimmer";
		
		var modkey = "Externals/" + id + "/";
		var dkey = modkey + "Desc";		
		var dkeylower = keystd(dkey);
		
		var outer = "";

		// append configuration
		outer += "<div class='moddetail'>";

		// module details				
		var ma = false;
		switch (type) {
			case "F9":
				var chs = new Array("1R","2G","3B");
				outer += "<table class='regconf'>";
				outer += "<tr><th style='text-align:center' colspan=3><span name='" + dkeylower + "'>" + getkey(dkey, dfltname) + 
					"</span> - Configuration (ID " + id + ")</th></tr>";
				outer += "<tr><th colspan=2 >Name</th><td>" + textbox(dkey, dfltname) + "</td></tr>";
				for (var i = 0; i < 3; i++) {
					var chkey = modkey + "Chan" + chs[i] + "/";
					outer += "<tr><th>" + checkbox(chkey + "Enable", "enabled") + " Chan " + chs[i] + "</th>" +
							"<th>Description</th><td>" + textbox(chkey + "Desc", "Channel " + chs[i]) + "</td></tr>";

				}
				outer += "</table>";
				break;
			case "FB":
				var chs = " ABCD";
				outer += "<table class='regconf'>";
				outer += "<tr><th style='text-align:center' colspan=3><span name='" + dkeylower + "'>" + getkey(dkey, dfltname) + 
					"</span> - Configuration (ID " + id + ")</th></tr>";
				outer += "<tr><th colspan=2 >Name</th><td>" + textbox(dkey, dfltname) + "</td></tr>";
				for (var i = 1; i < 5; i++) {
					var chkey = modkey + "Rout" + chs[i] + "/";
					outer += "<tr><th rowspan=3>" + checkbox(chkey + "Enable", "enabled") + " Relay " + chs[i] + "</th>" +
							"<th>Description</th><td>" + textbox(chkey + "Desc", "Relay Output " + chs[i]) + "</td></tr>";
					outer += "<tr><th>On Text</th><td>" + textbox(chkey + "OnText", "ON") + "</td></tr>";
					outer += "<tr><th>Off Text</th><td>" + textbox(chkey + "OffText", "OFF") + "</td></tr>";
				}
				outer += "</table>";
				break;
			case "10":
			case "28":
				outer += "<table class='regconf'>";
				outer += "<tr><th style='text-align:center' colspan=2><span name='" + dkeylower + "'>" + getkey(dkey, dfltname) + 
					"</span> - Configuration (ID " + id + ")</th></tr>";
				outer += "<tr><th>Name</th><td>" + textbox(dkey, dfltname) + "</td></tr>";
				outer += "<tr><th>Fahrenheit</th><td>" + checkbox(modkey + "Fahrenheit", "false") + "</td></tr>";
				outer += "</table>";
				break;
			case "FA":
				outer += "<table class='regconf'>";
				outer += "<tr><th style='text-align:center' colspan=2><span name='" + dkeylower + "'>" + getkey(dkey, dfltname) + 
					"</span> - Configuration (ID " + id + ")</th></tr>";
					outer += "<tr><th>Description</th><td>" + textbox(modkey + "Desc", "Control Panel") + "</td></tr>";
					for (var i = 1; i < 13; i++) {
						outer += "<tr><th>LED L" + i + "</th><td>" + textbox(modkey + "L" + i + "desc", "L" + i) + "</td></tr>";
					}
				outer += "</table>";
				break;
			case "FE":
				ma = true;
			case "FD":
				outer += "<table class='regconf'>";
				outer += "<tr><th style='text-align:center' colspan=3><span name='" + dkeylower + "'>" + getkey(dkey, dfltname) + 
					"</span> - Configuration (ID " + id + ")</th></tr>";
				outer += "<tr><th colspan=2 >Name</th><td>" + textbox(dkey, dfltname) + "</td></tr>";
				for (var i = 1; i < 5; i++) {
					var chkey = modkey + "Ain" + i + "/";
					outer += "<tr><th rowspan=5>" + checkbox(chkey + "Enable", "enabled") + " Input " + i + "</th>" +
							"<th>Description</th><td>" + textbox(chkey + "Desc", "Channel " + i) + "</td></tr>";
					outer += "<tr><th>Units</th><td>" + textbox(chkey + "Units", ma ? "ma" : "V") + "</td></tr>";
					outer += "<tr><th>Range Min</th><td>" + textbox(chkey + "Min", ma ? "4.0" : "-10.0") + "</td></tr>";
					outer += "<tr><th>Range Max</th><td>" + textbox(chkey + "Max", ma ? "20.0" : "10.0") + "</td></tr>";
					outer += "<tr><th>Decimals</th><td>" + textbox(chkey + "Decimals", "2") + "</td></tr>";
				}
				for (var i = 1; i < 3; i++) {
					var chkey = modkey + "Aout" + i + "/";
					outer += "<tr><th rowspan=5>" + checkbox(chkey + "Enable", "true") + " Output " + i + "</th>" +
							"<th>Description</th><td>" + textbox(chkey + "Desc", "Analog Output " + i) + "</td></tr>";
					outer += "<tr><th>Units</th><td>" + textbox(chkey + "Units", "%") + "</td></tr>";
					outer += "<tr><th>Range Min</th><td>" + textbox(chkey + "Min", "0.0") + "</td></tr>";
					outer += "<tr><th>Range Max</th><td>" + textbox(chkey + "Max", "100.0") + "</td></tr>";
					outer += "<tr><th>Decimals</th><td>" + textbox(chkey + "Decimals", "2") + "</td></tr>";
				}
				outer += "</table>";
				break;
				
			default:
				outer += "<table class='regconf'>";
				outer += "<tr><th style='text-align:center' colspan=2><span name='" + dkeylower + "'>" + getkey(dkey, dfltname) + 
					"</span> - Configuration (ID " + id + ")</th></tr>";
				outer += "<tr><th>Name</th><td>" + textbox(dkey, dfltname) + "</td></tr>";
				outer += "</table>";
				break;
		}

		outer += "</div>";
		conf.innerHTML = outer;
	}
}

// Expands module for configuration
function modexpand(id) {
	config_module = id;
	update_modulelist();
	module_conf(id);
	return false;
}

// Function to generate registry textbox
function textbox(key, dflt) {
	var val = getkey(key, dflt);
	return "<input class='field' type='text' name='" + keystd(key) + "' title='" + key + "' value='" + val +
			"' size=50 onfocus='snapTextbox(event);' onblur='updateTextbox(event);' onkeydown='textKeydown(event);' />";
}

// Function to generate registry checkbox
function checkbox(key, dflt) {
	var val = istrue(getkey(key, dflt));
	return "<input type='checkbox' name='" + keystd(key) + "' title='" + key + "' onclick='updateCheckbox(event);return false;'" + (val ? " checked>" : ">");
}


// Function to query the value of a key
function getkey(key, dflt) {
	key = keystd(key);
	var desc = registry_cache[key];
	if (desc == null || desc == undefined)
		desc = registry_default[key];
	if (desc == null || desc == undefined) {
		registry_default[key] = dflt;
		desc = dflt;

		// request this key
		var request = new Object();
		request['Message'] = "Registry Read";
  	request['Keys'] = new Array(key);
 	  chan.sendJson(request);
	}
	return desc;
}

// Function to create the HTML for the External Input/Output page
function update_externals(redisplay) {
	
	// Obtain keys for sorting
	var keys = new Array();
	var n = 0;
	var id;
	for (id in module_idToKey) {
		// modules types that we can render that are connected
		var type = id.substring(14);
		if (module_present.indexOf(id) != -1) {
			var key = module_idToKey[id];
			keys[n++] = key;
		}
	}
	keys.sort();
	
	// To update the external module display we first remove blocks for devices that are no longer connected.
	var table = document.getElementById('exttable');
	var devs = document.getElementsByClassName('devblock');
	for (var n = 0; n < devs.length; n++) {
		var ids = devs[n].id.split(":");
		var i = 0;
		for (; i < keys.length; i++) {
			var id = module_keyToId[keys[i]];
			if (id == ids[1])
				break;
		}
		
		// if device shown but no longer reported
		if (i == keys.length)
			table.removeChild(devs[n]);
	}
	
	// Next we add new devices to the table and update content
	var devs = document.getElementsByClassName('devblock');
	for (var n = 0; n < keys.length; n++) {
		var id = module_keyToId[keys[n]];
		var idn = "dev:" + id;
		var i = 0;
		for (; i < devs.length; i++) {
			if (devs[i].id == idn)
				break;
		}
		
		// if device not yet displayed we add it
		if (i == devs.length) {
			var dev = document.createElement('tr')
			dev.className = "devblock";
			dev.id = idn;
			table.appendChild(dev);
			
			dev = document.getElementById(idn);
			device_block(dev, keys[n]);
		}
		else if (redisplay)
			device_block(devs[i], keys[n]);
			
		// finally update content
		update_dev(keys[n]);
	}
}

// Function returns HTML for the module
function device_block(elem, key) {
	var type = module_keyToId[key].substring(14);
	switch (type) {
		case "F9":
			device_dimmer(elem, key);
			break;
		case "FA":
			elem.innerHTML = device_FA(key);
			break;
		case "FB":
			elem.innerHTML = device_relays(key);
			break;
		case "FD":
		case "FE":
			elem.innerHTML = device_analog(key);
			break;
		case "10":
		case "28":
			elem.innerHTML = device_temp(key);
			break;
		default:
			elem.innerHTML = device_unknown(key);
			break;
	}
}

// Function returns HTML for an unknown sensor
function device_unknown(key) {
	var id = module_keyToId[key];
	var modkey = "externals/" + id.toLowerCase() + "/";
	var desc_key = modkey + "Desc";
	var desc = getkey(desc_key, "Unknown Device");
	
	var inner = "<td name='unknown'>";
	inner += "<p class='modname' name='" + keystd(desc_key) + "'>" + desc + "</span></p>";
	inner += "<p class='modaddr'>" + id + "</p>";
	inner += "</td>";
	return inner;
}



// Function updates content for the module
function update_dev(key) {
	var type = module_keyToId[key].substring(14);
	switch (type) {
		case "F9":
			return update_dimmer(key);
		case "FA":
			return update_FA(key);
		case "FB":
			return update_relays(key);
		case "FD":
		case "FE":
			return update_analog(key);
		case "10":
		case "28":
			return update_temp(key);
	}
	return false;
}
function pulse(channel) {
	var elem = document.getElementsByName('io/outputs/rout' + channel + '/pulseduration');
	var duration = elem[0].value;
	
	var request = new Object();
	request['Message'] = "Control";
	request['Command'] = "Toggle";
	request['Channel'] = channel;
	request['Duration'] = duration;
	chan.sendJson(request);
}

function release(channel) {
	var request = new Object();
	request['Message'] = "Control";
	request['Command'] = "Reset Latch";
	request['Channel'] = channel;
	chan.sendJson(request);
}

// Function deletes tracking keys unconnected modules
function rescan(event) {
	var keys = null;
	var id;

	// select modules that are not present and attempt to remove the key		
	for (id in module_idToKey) {
		if (module_idToStatus[id] == null || module_idToStatus[id] == "") {
			if (keys === null)
				keys = new Object();
			keys[module_idToKey[id]] = "";
		}
	}

	if (keys !== null) {		
		var update = new Object();
		update['Message'] = "Registry Write";
	  update['Keys'] = keys;
	  chan.sendJson(update);
	}
	
	event.preventDefault();
}

// Toggles visibility of the External group assignment popup
function routa() {
	el = document.getElementById('routa');
	el.style.display = getComputedStyle(el).getPropertyValue('display') == "none" ? "inherit" : "none";
}

// Clicked Assignment for module. This initializes the popup and displays it.
function routAssign(key, id, type) {
	document.getElementById('rident').innerHTML = id;
	document.getElementById('rkey').innerHTML = key;
	
	var channel = parseInt(key.substring(key.indexOf("_") + 1));
	if (type == "FB") {
		if (jnior_model != 412) {
			if (jnior_model == 414) {
				var btnB = document.getElementById('btnB');
				btnB.checked = (channel == 1);
			}
			else channel++;
				
			var btnC = document.getElementById('btnC');
			btnC.checked = (channel == 2);
			var btnD = document.getElementById('btnD');
			btnD.checked = (channel == 3);
		}
	}
	routa();
}

// Clicked Cancel. Hide popup.
function routaCancel() {
	routa();
}

// Clicked OK. Determines action and does it. Popup is hidden.
function routaOK() {
	var id1 = document.getElementById('rident').innerHTML;
	var key = document.getElementById('rkey').innerHTML;
	var channel = parseInt(key.substring(key.indexOf("_") + 1));
	var type = "Externals/DeviceOrder/TypeFB_";
	var key1 = type + channel;
	var targ = 0;
	
	// determine selected output block
	if (jnior_model == 412) 
		targ = 3;
	else {
		var btnD = document.getElementById('btnD');
		if (btnD.checked) 
			targ = 3;
		else {
			var btnC = document.getElementById('btnC');
			if (btnC.checked) 
				targ = 2;
			else if (jnior_model == 414) {
				var btnB = document.getElementById('btnB');
				if (btnB.checked)
					targ = 1;
			}
		}
	}
	
	// select the target key
	if (targ > 0) {
		if (jnior_model == 412)
			targ -= 2;
		else if (jnior_model == 410)
			targ -= 1;

		if (targ != channel) {			
			var key2 = type + targ;
			var id2 = module_keyToId[key2.toLowerCase()];
			
			var keys = new Object();
			keys[key1] = id2;
			keys[key2] = id1;
		
			var update = new Object();
			update['Message'] = "Registry Write";
		  update['Keys'] = keys;
		  chan.sendJson(update);
		}
	}
	
	routa();
}

function clrcnt(channel) {
	if (confirm("Clear Input Counter?")) {
		var request = new Object();
		request['Message'] = "Control";
		request['Command'] = "Reset Counter";
		request['Channel'] = channel;
	  chan.sendJson(request);
	}
}

function clruse(channel) {
	if (confirm("Clear Usage Meter?")) {
		var request = new Object();
		request['Message'] = "Control";
		request['Command'] = "Reset Usage";
		request['Channel'] = channel;
	  chan.sendJson(request);
	}
}

function logout(){
		var url = window.location.href;
    var str = url.replace("://", "://" + new Date().getTime() + "@");
    var xmlhttp;
    if (window.XMLHttpRequest) 
    	xmlhttp=new XMLHttpRequest();
    else 
    	xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
    
    xmlhttp.onreadystatechange=function() {
        if (xmlhttp.readyState==4) location.reload();
    }

    xmlhttp.open("GET", str, true);
    xmlhttp.send();
    return false;
}