/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.snmp;

import com.integ.common.externalmodules.EnvironSensor;
import com.integ.common.externalmodules.ExternalDevice;
import com.integ.common.externalmodules.ExternalDeviceMap;
import com.integ.common.externalmodules.FourTwentyModule;
import com.integ.common.externalmodules.PresentDevices;
import com.integ.common.externalmodules.TempProbe;
import com.integ.common.externalmodules.TenVoltModule;
import com.integ.common.logging.AppLog;
import com.integpg.snmp.Config;
import com.integpg.snmp.ExternalTempToSnmp;
import com.integpg.snmp.SNMPStore;
import com.integpg.snmp.objects.SNMPInteger;
import com.integpg.snmp.objects.SNMPObject;
import com.integpg.snmp.objects.SNMPOctetString;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Hashtable;

class ExternalModuleInteregator
implements Runnable {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.000");
    private static Thread _thread;
    private String[] _allDeviceTypeOrderStrings;
    private long _lastDeviceOrderRegistryModifiedTime = 0L;
    private Hashtable<String, ExternalTempToSnmp> _moduleCache = new Hashtable();

    ExternalModuleInteregator() {
    }

    static void start() {
        if (null == _thread) {
            ExternalModuleInteregator externalModuleInteregator = new ExternalModuleInteregator();
            _thread = new Thread(externalModuleInteregator);
            _thread.setName(externalModuleInteregator.getClass().getName());
            _thread.start();
        }
    }

    @Override
    public void run() {
        while (true) {
            this.doLoop();
            this.doSleep();
        }
    }

    private void doLoop() {
        Enumeration<ExternalDevice> externalDevices = ExternalDeviceMap.elements();
        while (externalDevices.hasMoreElements()) {
            ExternalDevice externalModule = externalDevices.nextElement();
            if (!PresentDevices.isPresent(externalModule.DeviceAddressString)) continue;
            try {
                externalModule.read();
                if (externalModule instanceof TempProbe) {
                    this.updateTemperatureProbe((TempProbe)externalModule);
                    continue;
                }
                if (externalModule instanceof EnvironSensor) {
                    this.updateEnvironmentalSensor((EnvironSensor)externalModule);
                    continue;
                }
                if (externalModule instanceof TenVoltModule) {
                    this.updateTenVoltModule((TenVoltModule)externalModule);
                    continue;
                }
                if (!(externalModule instanceof FourTwentyModule)) continue;
                this.updateFourTwentyModule((FourTwentyModule)externalModule);
            }
            catch (Throwable ex) {
                AppLog.error("error reading " + externalModule.DeviceAddressString, ex);
            }
        }
    }

    private void updateTemperatureProbe(TempProbe type28) {
        int moduleIndex = type28.DeviceIndex;
        int type = 40;
        String baseOid = "1.3.6.1.4.1.31976.1.1.5." + type + ".1.";
        SNMPStore.insertPair(baseOid + "1." + moduleIndex, (SNMPObject)new SNMPInteger(type28.DeviceIndex));
        SNMPStore.insertPair(baseOid + "2." + moduleIndex, (SNMPObject)new SNMPOctetString(DECIMAL_FORMAT.format(type28.getCelsius())));
        SNMPStore.insertPair(baseOid + "3." + moduleIndex, (SNMPObject)new SNMPOctetString(DECIMAL_FORMAT.format(type28.getFahrenheit())));
    }

    private void updateEnvironmentalSensor(EnvironSensor type7E) {
        int moduleIndex = type7E.DeviceIndex;
        int type = 126;
        String baseOid = "1.3.6.1.4.1.31976.1.1.5." + type + ".1.";
        SNMPStore.insertPair(baseOid + "1." + moduleIndex, (SNMPObject)new SNMPInteger(moduleIndex));
        SNMPStore.insertPair(baseOid + "2." + moduleIndex, (SNMPObject)new SNMPOctetString(DECIMAL_FORMAT.format(type7E.getCelsius())));
        SNMPStore.insertPair(baseOid + "3." + moduleIndex, (SNMPObject)new SNMPOctetString(DECIMAL_FORMAT.format(type7E.getFahrenheit())));
        SNMPStore.insertPair(baseOid + "4." + moduleIndex, (SNMPObject)new SNMPOctetString(DECIMAL_FORMAT.format(type7E.getHumidity())));
    }

    private void updateTenVoltModule(TenVoltModule typeFD) {
        int moduleIndex = typeFD.DeviceIndex;
        int type = 253;
        String baseOid = "1.3.6.1.4.1.31976.1.1.5." + type + ".1.";
        SNMPStore.insertPair(baseOid + "1." + moduleIndex, (SNMPObject)new SNMPInteger(moduleIndex));
        SNMPStore.insertPair(baseOid + "2." + moduleIndex, (SNMPObject)new SNMPOctetString(DECIMAL_FORMAT.format(typeFD.getScaledInput(1))));
        SNMPStore.insertPair(baseOid + "3." + moduleIndex, (SNMPObject)new SNMPOctetString(DECIMAL_FORMAT.format(typeFD.getScaledInput(2))));
        SNMPStore.insertPair(baseOid + "4." + moduleIndex, (SNMPObject)new SNMPOctetString(DECIMAL_FORMAT.format(typeFD.getScaledInput(3))));
        SNMPStore.insertPair(baseOid + "5." + moduleIndex, (SNMPObject)new SNMPOctetString(DECIMAL_FORMAT.format(typeFD.getScaledInput(4))));
        SNMPStore.insertPair(baseOid + "6." + moduleIndex, (SNMPObject)new SNMPOctetString(DECIMAL_FORMAT.format(typeFD.getScaledOutput(1))));
        SNMPStore.insertPair(baseOid + "7." + moduleIndex, (SNMPObject)new SNMPOctetString(DECIMAL_FORMAT.format(typeFD.getScaledOutput(2))));
    }

    private void updateFourTwentyModule(FourTwentyModule typeFE) {
        int moduleIndex = typeFE.DeviceIndex;
        int type = 254;
        String baseOid = "1.3.6.1.4.1.31976.1.1.5." + type + ".1.";
        SNMPStore.insertPair(baseOid + "1." + moduleIndex, (SNMPObject)new SNMPInteger(moduleIndex));
        SNMPStore.insertPair(baseOid + "2." + moduleIndex, (SNMPObject)new SNMPOctetString(DECIMAL_FORMAT.format(typeFE.getScaledInput(1))));
        SNMPStore.insertPair(baseOid + "3." + moduleIndex, (SNMPObject)new SNMPOctetString(DECIMAL_FORMAT.format(typeFE.getScaledInput(2))));
        SNMPStore.insertPair(baseOid + "4." + moduleIndex, (SNMPObject)new SNMPOctetString(DECIMAL_FORMAT.format(typeFE.getScaledInput(3))));
        SNMPStore.insertPair(baseOid + "5." + moduleIndex, (SNMPObject)new SNMPOctetString(DECIMAL_FORMAT.format(typeFE.getScaledInput(4))));
        SNMPStore.insertPair(baseOid + "6." + moduleIndex, (SNMPObject)new SNMPOctetString(DECIMAL_FORMAT.format(typeFE.getScaledOutput(1))));
        SNMPStore.insertPair(baseOid + "7." + moduleIndex, (SNMPObject)new SNMPOctetString(DECIMAL_FORMAT.format(typeFE.getScaledOutput(2))));
    }

    private void doSleep() {
        try {
            int externalQueryInterval = Config.getExternalQueryInterval();
            if (0 >= externalQueryInterval) {
                externalQueryInterval = 15000;
            }
            Thread.sleep(externalQueryInterval);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace(System.err);
        }
    }
}

