/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker;

import com.integ.tasker.FileModifiedEvent;
import com.integ.tasker.FileModifiedListener;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.text.QuickDateFormat;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class ConfigurationFileMonitor
implements Runnable {
    private static final ConfigurationFileMonitor INSTANCE = new ConfigurationFileMonitor();
    private static final Hashtable<File, FileModifiedListener> LISTENER_BY_FILE = new Hashtable();
    private static final Hashtable<File, Long> LAST_MODIFIED_TIME_BY_FILE = new Hashtable();
    private static Thread Thread = null;

    public static void addFile(File file, FileModifiedListener fileModifiedListener) {
        AppLog.info("Added " + file.getAbsolutePath() + " to the Configuration Monitor");
        LISTENER_BY_FILE.put(file, fileModifiedListener);
        LAST_MODIFIED_TIME_BY_FILE.put(file, 0L);
    }

    public static void start() {
        if (null == Thread) {
            Thread = new Thread(INSTANCE);
            Thread.setName(INSTANCE.getClass().getName());
            Thread.setDaemon(true);
            Thread.start();
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    ArrayList<File> files = this.getFiles();
                    boolean allFilesProcessed = true;
                    for (File file : files) {
                        if (!file.exists()) continue;
                        long lastModifiedTime = LAST_MODIFIED_TIME_BY_FILE.get(file);
                        if (file.lastModified() == lastModifiedTime) continue;
                        if (0L != lastModifiedTime) {
                            AppLog.info(file.getPath() + " has been modified at " + QuickDateFormat.getDefault().format(file.lastModified()));
                        }
                        allFilesProcessed &= this.processFile(file);
                    }
                    if (!allFilesProcessed) continue;
                    java.lang.Thread.sleep(10000L);
                }
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    private boolean processFile(File file) {
        boolean fileProcessed = false;
        FileModifiedListener fileModifiedListener = LISTENER_BY_FILE.get(file);
        if (null != fileModifiedListener) {
            fileProcessed = fileModifiedListener.fileModified(new FileModifiedEvent(this, file));
        }
        if (fileProcessed) {
            LAST_MODIFIED_TIME_BY_FILE.put(file, file.lastModified());
        }
        return fileProcessed;
    }

    public static void forceReload() {
        Thread.interrupt();
    }

    private ArrayList<File> getFiles() {
        ArrayList<File> files = new ArrayList<File>();
        Enumeration<File> filesEnum = LAST_MODIFIED_TIME_BY_FILE.keys();
        while (filesEnum.hasMoreElements()) {
            files.add(filesEnum.nextElement());
        }
        return files;
    }
}

