/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.threading.timers;

import com.integpg.janoslib.debug.ThreadElapsed;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.logging.Logger;
import com.integpg.janoslib.system.Application;
import com.integpg.janoslib.threading.timers.TimerQueue;
import com.integpg.janoslib.threading.timers.TimerTask;

public class Timer
implements Runnable {
    public static final Logger LOG = Logger.getLogger("/temp/" + Application.getAppName() + "_threading.log").enableLogThreadName();
    private final String _name;
    private Thread _thd;
    private final TimerQueue _timerTasks = new TimerQueue();
    private TimerTask _nextTimerTask = null;

    public Timer(String name) {
        this._name = name;
    }

    public void addTimerTask(TimerTask timerTask) {
        System.out.println("Add timer task " + timerTask);
        if (null == timerTask) {
            throw new RuntimeException("Cannot add a null timer task");
        }
        this._timerTasks.addTimerTask(timerTask);
        if (null != this._thd) {
            this._thd.interrupt();
        } else {
            this.start();
        }
    }

    public void start() {
        if (null == this._thd) {
            this._thd = new Thread(this);
            this._thd.setName(this.getClass().getName() + ":" + this._name);
            this._thd.setDaemon(true);
            this._thd.start();
        }
    }

    @Override
    public void run() {
        try {
            AppLog.info(Thread.currentThread().getName() + " started");
            this.mainTimerLoop();
        }
        catch (Exception ex) {
            AppLog.fatal("error in timer main loop");
            LOG.error("error in timer main loop", ex);
            System.err.println(ex);
            Application.exit(-5);
        }
    }

    private void mainTimerLoop() {
        while (true) {
            this.sleepUntilNextTask();
            if (null == this._nextTimerTask || !this._nextTimerTask.shouldTrigger()) continue;
            if (!this._nextTimerTask.isDone()) {
                this._nextTimerTask.run();
            }
            this.updateTimerTask();
        }
    }

    private void sleepUntilNextTask() {
        try {
            long nextExecutionTime = this.getNextExecutionTime();
            long sleepDuration = nextExecutionTime - System.currentTimeMillis();
            if (0L < sleepDuration) {
                System.out.println(ThreadElapsed.getElapsed() + "Timer sleep for " + sleepDuration);
                Thread.sleep(sleepDuration);
            } else {
                LOG.info(this._nextTimerTask.getName() + ": " + Math.abs(sleepDuration) + " millis late");
            }
        }
        catch (InterruptedException ex) {
            System.out.println("Timer Interrupted");
        }
        catch (Exception ex) {
            LOG.error(ex);
        }
    }

    private long getNextExecutionTime() {
        do {
            TimerTask nextTimerTask;
            if (null != (nextTimerTask = this._timerTasks.getNextTimerTask()) && nextTimerTask.isDone()) {
                System.out.println("remove done time task");
                this._timerTasks.removeNextTimer();
            }
            this._nextTimerTask = this._timerTasks.getNextTimerTask();
        } while (null != this._nextTimerTask && this._nextTimerTask.isDone());
        return null != this._nextTimerTask ? this._nextTimerTask.getNextExecutionTime() : Long.MAX_VALUE;
    }

    private void updateTimerTask() {
        TimerTask timerTask = this._timerTasks.removeNextTimer();
        timerTask.updateExecutionTime();
        if (!timerTask.isDone()) {
            this._timerTasks.addTimerTask(timerTask);
        }
    }
}

