/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.lexer;

import com.integpg.janoslib.datastructures.Queue;
import com.integpg.janoslib.debug.DEBUG;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.lexer.Token;

public class Lexer {
    private static String getString(String s, int i) {
        for (int j = i; j < s.length(); ++j) {
            char c = s.charAt(j);
            if (c == '\\') {
                ++j;
            }
            if (c != '\"') continue;
            return s.substring(i, j);
        }
        return null;
    }

    private static boolean isLetter(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
    }

    private static boolean isSpecialCharacter(char c) {
        boolean specialChar = c == '$' || c == '_';
        return specialChar;
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9' || c == '.';
    }

    private static boolean isWhitespace(char c) {
        return c <= ' ';
    }

    public static int parse(Queue<Token> result, String script) throws Exception {
        if (DEBUG.ON) {
            AppLog.info("Lexer.parse(): " + script);
        }
        int linePos = 1;
        int colPos = 1;
        try {
            int last = -1;
            int i = 0;
            int scriptLength = script.length();
            block17: while (i < scriptLength) {
                int start;
                char c = script.charAt(i);
                if (i == last) {
                    throw new Exception("Parser encountered unknown character " + c + " @ " + (i + 1));
                }
                last = i;
                switch (c) {
                    case '\\': {
                        char nextChar;
                        if (i + 3 < scriptLength && (nextChar = script.charAt(i + 1)) == 'x') {
                            String hexChar = String.format("%c%c", Character.valueOf(script.charAt(i + 2)), Character.valueOf(script.charAt(i + 3)));
                            result.enqueue(new Token(15, hexChar, linePos, colPos));
                            i += 4;
                            continue block17;
                        }
                    }
                    case '%': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case ',': 
                    case ':': 
                    case ';': 
                    case '?': 
                    case '[': 
                    case ']': 
                    case '^': 
                    case '{': 
                    case '}': {
                        result.enqueue(new Token(c, String.valueOf(c), linePos, colPos));
                        ++i;
                        continue block17;
                    }
                    case '=': {
                        char nextChar;
                        if (i + 1 < scriptLength && (nextChar = script.charAt(i + 1)) == '=') {
                            result.enqueue(new Token(11, "==", linePos, colPos));
                            i += 2;
                            continue block17;
                        }
                        result.enqueue(new Token(c, String.valueOf(c), linePos, colPos));
                        ++i;
                        continue block17;
                    }
                    case '!': {
                        char nextChar;
                        if (i + 1 < scriptLength && (nextChar = script.charAt(i + 1)) == '=') {
                            result.enqueue(new Token(12, "!=", linePos, colPos));
                            i += 2;
                            continue block17;
                        }
                        result.enqueue(new Token(33, String.valueOf(c), linePos, colPos));
                        ++i;
                        continue block17;
                    }
                    case '<': {
                        char nextChar;
                        if (i + 1 < scriptLength && (nextChar = script.charAt(i + 1)) == '=') {
                            result.enqueue(new Token(14, "<=", linePos, colPos));
                            i += 2;
                            continue block17;
                        }
                        result.enqueue(new Token(60, String.valueOf(c), linePos, colPos));
                        ++i;
                        continue block17;
                    }
                    case '>': {
                        char nextChar;
                        if (i + 1 < scriptLength && (nextChar = script.charAt(i + 1)) == '=') {
                            result.enqueue(new Token(13, ">=", linePos, colPos));
                            i += 2;
                            continue block17;
                        }
                        result.enqueue(new Token(62, String.valueOf(c), linePos, colPos));
                        ++i;
                        continue block17;
                    }
                    case '|': {
                        char nextChar;
                        if (i + 1 < scriptLength && (nextChar = script.charAt(i + 1)) == '|') {
                            result.enqueue(new Token(9, "||", linePos, colPos));
                            i += 2;
                            continue block17;
                        }
                        result.enqueue(new Token(c, String.valueOf(c), linePos, colPos));
                        ++i;
                        continue block17;
                    }
                    case '&': {
                        char nextChar;
                        if (i + 1 < scriptLength && (nextChar = script.charAt(i + 1)) == '&') {
                            result.enqueue(new Token(10, "&&", linePos, colPos));
                            i += 2;
                            continue block17;
                        }
                        result.enqueue(new Token(c, String.valueOf(c), linePos, colPos));
                        ++i;
                        continue block17;
                    }
                    case '+': {
                        if (i + 1 < scriptLength) {
                            char nextChar = script.charAt(i + 1);
                            if (nextChar == '+') {
                                result.enqueue(new Token(5, "++", linePos, colPos));
                                i += 2;
                                continue block17;
                            }
                            if (nextChar == '=') {
                                result.enqueue(new Token(6, "+=", linePos, colPos));
                                i += 2;
                                continue block17;
                            }
                        }
                        result.enqueue(new Token(c, String.valueOf(c), linePos, colPos));
                        ++i;
                        continue block17;
                    }
                    case '-': {
                        if (i + 1 < scriptLength) {
                            char nextChar = script.charAt(i + 1);
                            if (nextChar == '-') {
                                result.enqueue(new Token(7, "--", linePos, colPos));
                                i += 2;
                                continue block17;
                            }
                            if (nextChar == '=') {
                                result.enqueue(new Token(8, "-=", linePos, colPos));
                                i += 2;
                                continue block17;
                            }
                            if (Lexer.isDigit(nextChar)) {
                                boolean digit;
                                int start2 = i;
                                int charPos = start2 + 1;
                                for (boolean isNumeric = true; isNumeric && charPos < scriptLength; isNumeric &= digit) {
                                    c = script.charAt(charPos++);
                                    digit = Lexer.isDigit(c);
                                }
                                if (charPos == scriptLength) {
                                    ++charPos;
                                }
                                String number = script.substring(start2, charPos - 1);
                                i = charPos - 1;
                                result.enqueue(new Token(3, number, linePos, colPos));
                                colPos += number.length();
                                continue block17;
                            }
                        }
                        result.enqueue(new Token(c, String.valueOf(c), linePos, colPos));
                        ++i;
                        continue block17;
                    }
                    case '/': {
                        if (i + 1 < scriptLength && script.charAt(i + 1) == '/') {
                            i += 2;
                            while ((c = script.charAt(i)) != '\n') {
                                ++i;
                            }
                            continue block17;
                        }
                        result.enqueue(new Token(c, String.valueOf(c), linePos, colPos));
                        ++i;
                        continue block17;
                    }
                    case '\"': {
                        String string = Lexer.getString(script, i + 1);
                        result.enqueue(new Token(4, string, linePos, colPos));
                        i += string.length() + 2;
                        colPos += string.length();
                        continue block17;
                    }
                    case '.': {
                        char nextChar = script.charAt(i + 1);
                        if (Lexer.isDigit(nextChar)) break;
                        result.enqueue(new Token(c, String.valueOf(c), linePos, colPos));
                        ++i;
                        continue block17;
                    }
                }
                if (Lexer.isWhitespace(c)) {
                    if (c == '\n') {
                        ++linePos;
                        colPos = 0;
                    }
                    ++colPos;
                    ++i;
                    continue;
                }
                int charPos = start = i;
                boolean isDigit = true;
                boolean isLetter = true;
                while ((isDigit || isLetter) && charPos < scriptLength) {
                    boolean letter;
                    c = script.charAt(charPos++);
                    boolean digit = isDigit && Lexer.isDigit(c);
                    boolean bl = letter = Lexer.isLetter(c) || Lexer.isSpecialCharacter(c);
                    if (!digit && !letter) {
                        --charPos;
                        break;
                    }
                    isDigit = digit;
                    isLetter = letter;
                }
                String word = script.substring(start, charPos);
                i = charPos;
                if (isDigit) {
                    result.enqueue(new Token(3, word, linePos, colPos));
                } else if (word.equals("true") || word.equals("false")) {
                    result.add(new Token(16, word, linePos, colPos));
                } else {
                    result.add(new Token(0, word, linePos, colPos));
                }
                colPos += word.length();
            }
            return i;
        }
        catch (Exception ex) {
            AppLog.error("Error on line " + (linePos + 1), ex);
            return -1;
        }
    }
}

