/*
 * Decompiled with CFR 0.152.
 */
package JniorProtocol.Registry;

import JniorProtocol.Exceptions.CommandTimeoutException;
import JniorProtocol.Exceptions.NotLoggedInException;
import JniorProtocol.Exceptions.NotYetConnectedException;
import JniorProtocol.JniorSession;
import JniorProtocol.Listeners.RegistryListener;
import JniorProtocol.ProtocolMessage;
import JniorProtocol.Registry.RegistryKey;
import JniorProtocol.Registry.RegistryRequest;
import JniorProtocol.Registry.RegistryStore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.EventObject;
import java.util.Vector;

public class Registry
extends ProtocolMessage {
    private static final boolean DEBUG = false;
    public static final int SEND_REGISTRY_SUBSCRIBE = 15;
    public static final int SEND_REGISTRY_READ = 11;
    public static final int RECV_REGISTRY_READ = 12;
    public static final int SEND_REGISTRY_WRITE = 13;
    public static final int RECV_REGISTRY_WRITE = 14;
    public static final int SEND_REGISTRY_LIST = 16;
    public static final int RECV_REGISTRY_LIST = 17;
    public static final int SEND_REGISTRY_UNSUBSCRIBE = 18;
    private static final int REGISTRY_TIMEOUT = 30000;
    public static final String REG_JNIOR_LOGIN = "JniorServer/Login";
    public static final String REG_ANONYMOUS = "JniorServer/Anonymous";
    private RegistryStore registryStore;
    private int m_writeResponseCount;
    private String listingNode;
    private String[] m_regList;
    private boolean m_regListReceived;
    private Vector m_registryListeners;

    public Registry(JniorSession jniorSession) {
        super(jniorSession);
        this.registryStore = new AbstractRegistryStore(this.m_session);
        this.m_writeResponseCount = -1;
        this.listingNode = null;
        this.m_registryListeners = new Vector();
    }

    public void addRegistryListener(RegistryListener registryListener) {
        if (registryListener == null) {
            return;
        }
        for (int i = 0; i < this.m_registryListeners.size(); ++i) {
            if (!((RegistryListener)this.m_registryListeners.elementAt(i)).equals(registryListener)) continue;
            return;
        }
        this.m_registryListeners.add(registryListener);
    }

    public Vector getAll() {
        return this.registryStore.getAll();
    }

    public RegistryKey getRegKey(String string) {
        return this.getRegKey(string, null);
    }

    public RegistryKey getRegKey(String string, String string2) {
        return this.getRegKey(string, string2, false);
    }

    public RegistryKey getRegKey(String string, String string2, boolean bl) {
        RegistryKey registryKey = this.registryStore.getByKey(string);
        if (registryKey == null) {
            registryKey = new InternalRegistryKey(string);
        }
        if (string2 != null) {
            registryKey.setValue(string2);
        }
        if (bl) {
            registryKey.setDefaultValue(string2);
        }
        return registryKey;
    }

    public void readRegistry(RegistryRequest registryRequest) throws CommandTimeoutException, NotYetConnectedException {
        this.readRegistry(registryRequest, false, false);
    }

    public void readRegistry(RegistryRequest registryRequest, boolean bl, boolean bl2) throws CommandTimeoutException, NotYetConnectedException {
        RegistryKey[] registryKeyArray = registryRequest.getAllKeys();
        int n = registryKeyArray.length;
        int n2 = 11;
        try {
            if (bl) {
                n2 = 15;
            }
            for (int i = 0; i < n; ++i) {
                RegistryKey registryKey = registryKeyArray[i];
                registryKey = this.registryStore.addKey(registryKey);
                registryKey.setPending();
            }
            this.buildReadPacket(registryKeyArray, n2);
            if (bl2) {
                long l = System.currentTimeMillis();
                long l2 = System.currentTimeMillis();
                while (this.m_session.isConnected() && registryRequest.getCountRemaining() > 0 && !this.isCommandTimeout(l2, 30000)) {
                    Thread.sleep(250L);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public void unsubscribeRegistry(RegistryRequest registryRequest) throws CommandTimeoutException, NotYetConnectedException {
        RegistryKey[] registryKeyArray = registryRequest.getAllKeys();
        int n = registryKeyArray.length;
        int n2 = 18;
        this.buildReadPacket(registryKeyArray, n2);
    }

    public String readRegistry(String string) throws CommandTimeoutException, NotYetConnectedException {
        return this.readRegistry(this.getRegKey(string));
    }

    public String readRegistry(String string, String string2) throws CommandTimeoutException, NotYetConnectedException {
        return this.readRegistry(this.getRegKey(string, string2));
    }

    public String readRegistry(RegistryKey registryKey) throws CommandTimeoutException, NotYetConnectedException {
        RegistryRequest registryRequest = new RegistryRequest();
        registryRequest.addKey(registryKey);
        this.readRegistry(registryRequest, false, true);
        return registryKey.getValue();
    }

    public String[] listRegistry(String string) throws CommandTimeoutException, NotYetConnectedException {
        return this.listRegistry(string, false);
    }

    public String[] listRegistry(String string, boolean bl) throws CommandTimeoutException, NotYetConnectedException {
        this.listingNode = string;
        byte[] byArray = new byte[1024];
        int n = 0;
        byArray[n++] = 16;
        byArray = Registry.setString(byArray, n, string);
        n += string.length() + 1;
        try {
            this.m_regListReceived = false;
            this.m_regList = null;
            this.send(byArray, 0, n);
            if (bl) {
                long l = System.currentTimeMillis();
                while (this.m_session.isConnected() && !this.m_regListReceived && !this.isCommandTimeout(l, 30000)) {
                    Thread.sleep(100L);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this.m_regList;
    }

    private void buildReadPacket(RegistryKey[] registryKeyArray, int n) throws NotYetConnectedException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(128);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.write(n);
            dataOutputStream.writeShort((short)registryKeyArray.length);
            for (int i = 0; i < registryKeyArray.length; ++i) {
                if (n != 18) {
                    dataOutputStream.writeShort(registryKeyArray[i].getUid());
                }
                dataOutputStream.write(Registry.sendString(registryKeyArray[i].getKey()));
            }
            this.send(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String subscribeRegistry(String string, String string2) throws CommandTimeoutException, NotYetConnectedException {
        return this.subscribeRegistry(string, string2, null);
    }

    public String subscribeRegistry(String string, String string2, RegistryListener registryListener) throws CommandTimeoutException, NotYetConnectedException {
        RegistryKey registryKey = this.getRegKey(string, string2);
        if (registryListener != null) {
            registryKey.addRegistryListener(registryListener);
        }
        return this.subscribeRegistry(registryKey);
    }

    public String subscribeRegistry(RegistryKey registryKey) throws CommandTimeoutException, NotYetConnectedException {
        RegistryRequest registryRequest = new RegistryRequest();
        registryRequest.addKey(registryKey);
        this.subscribeRegistry(registryRequest, true);
        return registryKey.getValue();
    }

    public void subscribeRegistry(RegistryRequest registryRequest) throws CommandTimeoutException, NotYetConnectedException {
        this.subscribeRegistry(registryRequest, false);
    }

    public void subscribeRegistry(RegistryRequest registryRequest, boolean bl) throws CommandTimeoutException, NotYetConnectedException {
        this.readRegistry(registryRequest, true, bl);
    }

    public void writeRegistry(String string, String string2) throws CommandTimeoutException, NotYetConnectedException, NotLoggedInException {
        this.writeRegistry(this.getRegKey(string, string2));
    }

    public void writeRegistry(RegistryKey registryKey) throws CommandTimeoutException, NotYetConnectedException, NotLoggedInException {
        RegistryRequest registryRequest = new RegistryRequest();
        registryRequest.addKey(registryKey);
        this.writeRegistry(registryRequest, true);
    }

    public void writeRegistry(RegistryRequest registryRequest, boolean bl) throws CommandTimeoutException, NotYetConnectedException, NotLoggedInException {
        this.m_session.isLoggedIn();
        RegistryKey[] registryKeyArray = registryRequest.getAllKeys();
        int n = registryKeyArray.length;
        try {
            for (int i = 0; i < n; ++i) {
                RegistryKey registryKey = registryKeyArray[i];
                registryKey = this.registryStore.addKey(registryKey);
            }
            this.buildWritePacket(registryKeyArray);
            if (bl) {
                long l = System.currentTimeMillis();
                long l2 = System.currentTimeMillis();
                while (this.m_session.isConnected() && this.m_writeResponseCount != n && !this.isCommandTimeout(l2, 30000)) {
                    Thread.sleep(250L);
                }
            }
        }
        catch (CommandTimeoutException commandTimeoutException) {
            this.m_session.printPackets();
            throw commandTimeoutException;
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public void removeFolder(String string) throws CommandTimeoutException, NotYetConnectedException, NotLoggedInException {
        String[] stringArray = this.listRegistry(string, true);
        RegistryRequest registryRequest = new RegistryRequest();
        for (int i = 0; i < stringArray.length; ++i) {
            registryRequest.addKey(this.getRegKey(string + "/" + stringArray[i], ""));
        }
        this.writeRegistry(registryRequest, true);
    }

    private void buildWritePacket(RegistryKey[] registryKeyArray) throws NotYetConnectedException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(128);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.write(13);
            dataOutputStream.writeShort((short)registryKeyArray.length);
            for (int i = 0; i < registryKeyArray.length; ++i) {
                dataOutputStream.write(Registry.sendString(registryKeyArray[i].getKey()));
                String string = registryKeyArray[i].getValue();
                if (string.equals(registryKeyArray[i].getDefaultValue())) {
                    string = "";
                }
                dataOutputStream.write(Registry.sendString(string));
            }
            this.send(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void receive(ByteArrayInputStream byteArrayInputStream, int n) {
        try {
            switch (n) {
                case 12: {
                    int n2 = Registry.getShort(byteArrayInputStream);
                    for (int n3 = 0; n3 < n2; n3 = (int)((short)(n3 + 1))) {
                        short s = (short)Registry.getShort(byteArrayInputStream);
                        String string = Registry.getString(byteArrayInputStream);
                        RegistryKey registryKey = this.registryStore.getByUid(s);
                        registryKey.setValue(string);
                        registryKey.clearPending();
                        if (!registryKey.key.equals("$Model")) continue;
                        if (registryKey.value.equals("312") || registryKey.value.equals("412")) {
                            this.m_session.getInternalsInstance().INPUTS = 4;
                            this.m_session.getInternalsInstance().OUTPUTS = 12;
                            continue;
                        }
                        if (!registryKey.value.equals("314") && !registryKey.value.equals("414")) continue;
                        this.m_session.getInternalsInstance().INPUTS = 12;
                        this.m_session.getInternalsInstance().OUTPUTS = 4;
                    }
                    break;
                }
                case 14: {
                    int n4;
                    this.m_writeResponseCount = n4 = Registry.getShort(byteArrayInputStream);
                    break;
                }
                case 17: {
                    int n5 = Registry.getShort(byteArrayInputStream);
                    this.m_regList = new String[n5];
                    for (int i = 0; i < n5; ++i) {
                        this.m_regList[i] = Registry.getString(byteArrayInputStream);
                    }
                    this.m_regListReceived = true;
                    this.fireRegistryListingReceivedEvent();
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void fireRegistryListingReceivedEvent() {
        int n = 0;
        while (n < this.m_registryListeners.size()) {
            final int n2 = n++;
            new Thread(new Runnable(){

                public void run() {
                    ((RegistryListener)Registry.this.m_registryListeners.elementAt(n2)).onRegistryListReceived(new EventObject(Registry.this.m_session), Registry.this.listingNode, Registry.this.m_regList);
                }
            }).start();
        }
    }

    class AbstractRegistryStore
    extends RegistryStore {
        public AbstractRegistryStore(JniorSession jniorSession) {
            super(jniorSession);
        }
    }

    class InternalRegistryKey
    extends RegistryKey {
        public InternalRegistryKey(String string) {
            this(string, "");
        }

        public InternalRegistryKey(String string, String string2) {
            this(string, string2, false);
        }

        public InternalRegistryKey(String string, String string2, boolean bl) {
            this.m_session = Registry.this.m_session;
            this.uid = InternalRegistryKey.getUniqueId(string);
            this.key = string;
            this.setValue(string2);
            if (bl) {
                this.defaultValue = this.defaultValue;
            }
        }
    }
}

