/*
 * Decompiled with CFR 0.152.
 */
package com.integ.registry;

import com.integ.registry.Comparator;
import java.util.ArrayList;

public class QuickSort<T> {
    private T[] _array;
    private int _length;
    private Comparator _comparator;

    public void sort(ArrayList<T> inputArrayList, Comparator comparator) {
        Object[] array = inputArrayList.toArray();
        this.sort(array, comparator);
        inputArrayList.clear();
        for (Object item : array) {
            inputArrayList.add(item);
        }
    }

    public void sort(T[] inputArr, Comparator comparator) {
        if (inputArr == null || inputArr.length == 0) {
            return;
        }
        this._array = inputArr;
        this._length = inputArr.length;
        this._comparator = comparator;
        this.quickSort(0, this._length - 1);
    }

    public void quickSort(int begin, int end) {
        if (begin < end) {
            int partitionIndex = this.partition(begin, end);
            this.quickSort(begin, partitionIndex - 1);
            this.quickSort(partitionIndex + 1, end);
        }
    }

    private int partition(int begin, int end) {
        T pivot = this._array[end];
        int i = begin - 1;
        for (int j = begin; j < end; ++j) {
            if (this._comparator.compare(this._array[j], pivot) >= 0) continue;
            this.swap(++i, j);
        }
        this.swap(i + 1, end);
        return i + 1;
    }

    private void swap(int i, int j) {
        T temp = this._array[i];
        this._array[i] = this._array[j];
        this._array[j] = temp;
        Thread.yield();
    }
}

