/*
 * Decompiled with CFR 0.152.
 */
package com.integ.registry;

import com.integpg.comm.SerialInputStream;
import java.io.IOException;

public class SystemPrintStream
extends SerialInputStream {
    public static final int NULL = 0;
    public static final int STDIN = 1;
    public static final int STDOUT = 2;
    public static final int STDERR = 3;
    public static final int COMIN = 4;
    public static final int COMOUT = 5;
    public static final int AUXIN = 6;
    public static final int AUXOUT = 7;
    private boolean inputEcho = true;
    public int inputHandle = 1;
    public int echoHandle = 2;
    private StringBuffer valueBuffer = new StringBuffer();
    private int setValueLength = 0;

    public SystemPrintStream() {
    }

    public SystemPrintStream(int hnd_in, int hnd_out) {
        this.inputHandle = hnd_in;
        this.echoHandle = hnd_out;
    }

    protected void open() {
    }

    public void close() {
    }

    private static native int getchar(int var0);

    private static native int avail(int var0);

    private static native void putchar(int var0, int var1);

    public synchronized int read() throws IOException {
        int ch = SystemPrintStream.getchar(this.inputHandle);
        if (8 == ch && 0 == this.valueBuffer.length()) {
            return 0;
        }
        if (ch == -1) {
            throw new IOException("timeout");
        }
        if (27 == ch && 0 < this.available()) {
            SystemPrintStream.getchar(this.inputHandle);
            SystemPrintStream.getchar(this.inputHandle);
            return 0;
        }
        if (this.inputEcho && this.echoHandle != 0) {
            SystemPrintStream.putchar(ch, this.echoHandle);
            if (8 == ch) {
                SystemPrintStream.putchar(32, this.echoHandle);
                SystemPrintStream.putchar(8, this.echoHandle);
                this.valueBuffer.setLength(this.valueBuffer.length() - 1);
            } else if (ch >= 32 && ch < 127) {
                this.valueBuffer.append((char)ch);
            }
        }
        return ch;
    }

    public String getValue() {
        return this.valueBuffer.toString();
    }

    public synchronized int available() {
        return SystemPrintStream.avail(this.inputHandle);
    }

    public synchronized void setEcho(boolean echo) {
        this.inputEcho = echo;
    }

    public synchronized void setValue(String value) {
        this.valueBuffer = new StringBuffer(value);
        this.setValueLength = value.length();
        for (int i = 0; i < value.length(); ++i) {
            SystemPrintStream.putchar(value.charAt(i), this.echoHandle);
        }
    }

    public String readLine() {
        this.valueBuffer.setLength(this.setValueLength);
        while (true) {
            try {
                int ch;
                do {
                    if (13 == (ch = this.read())) {
                        if (1 == this.available()) {
                            this.read();
                        }
                        String value = this.getValue();
                        System.out.println("");
                        this.setValueLength = 0;
                        return value;
                    }
                    if (10 != ch) continue;
                    String value = this.getValue();
                    this.setValueLength = 0;
                    return value;
                } while (27 != ch || 0 != this.available());
            }
            catch (IOException ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
        return null;
    }

    void enableReceiveThreshold(int thresh) {
        SystemPrintStream.commSetThreshEnable(this.inputHandle, thresh);
    }

    private static native void commSetThreshEnable(int var0, int var1);

    void disableReceiveThreshold() {
        SystemPrintStream.commSetThreshEnable(this.inputHandle, 0);
    }

    boolean isReceiveThresholdEnabled() {
        return SystemPrintStream.commGetThreshEnable(this.inputHandle) != 0;
    }

    private static native int commGetThreshEnable(int var0);

    void enableReceiveTimeout(int rcvTimeout) {
        SystemPrintStream.commSetTimeout(this.inputHandle, rcvTimeout);
    }

    private static native void commSetTimeout(int var0, int var1);

    void disableReceiveTimeout() {
        SystemPrintStream.commSetTimeout(this.inputHandle, 0);
    }

    boolean isReceiveTimeoutEnabled() {
        return SystemPrintStream.commGetTimeout(this.inputHandle) != 0;
    }

    private static native int commGetTimeout(int var0);

    int getHandle() {
        return this.inputHandle;
    }
}

