/*
 * Decompiled with CFR 0.152.
 */
package com.integ.registry;

import com.integ.registry.Comparator;
import com.integ.registry.QuickSort;
import com.integ.registry.StringComparer;
import com.integ.registry.SystemPrintStream;
import com.integpg.system.JANOS;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegistryMain {
    private final SystemPrintStream _in = new SystemPrintStream(1, 2);
    private String _key = "";
    private String _value = "";
    private static final Pattern NUMERIC_PATTERN = Pattern.compile("^-?\\d+(\\.\\d+)?$");

    public static void main(String[] args) {
        RegistryMain registryMain = new RegistryMain(args);
        registryMain.process();
    }

    public RegistryMain(String[] args) {
        System.setIn((InputStream)((Object)this._in));
        try {
            if (0 < args.length) {
                this._key = args[0];
                if (1 < args.length && "=".equals(args[1])) {
                    this._value = 2 < args.length ? args[2] : "";
                }
            } else {
                this._key = "";
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void process() {
        try {
            if (!"".equals(this._key)) {
                if (!"".equals(this._value)) {
                    JANOS.setRegistryString((String)this._key, (String)this._value);
                } else {
                    this.showContentFor(this._key, false);
                }
                return;
            }
            this.doCommandLoop();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void doCommandLoop() throws IOException {
        System.out.println("JNIOR Classic Registry Editor");
        String parentDirectory = "";
        while (true) {
            if ("".equals(parentDirectory) || parentDirectory.charAt(0) != '/') {
                parentDirectory = String.format("/%s", parentDirectory);
            }
            if (parentDirectory.charAt(parentDirectory.length() - 1) != '/') {
                parentDirectory = String.format("%s/", parentDirectory);
            }
            String[] registryListing = this.showContentFor(parentDirectory, true);
            System.out.println(String.format("%4d  <previous>", registryListing.length + 1));
            System.out.print("\nKey (or ## selection) to Add/Edit/Remove? ");
            String userResponse = this._in.readLine();
            if ("".equals(userResponse)) {
                System.exit(0);
            }
            if (!"/".equals(parentDirectory) && "..".equals(userResponse)) {
                parentDirectory = this.getPreviousDirectory(parentDirectory);
                continue;
            }
            if ("*".equals(userResponse)) {
                boolean removedAll = this.deleteDirectory(parentDirectory);
                if (!removedAll) continue;
                parentDirectory = this.getPreviousDirectory(parentDirectory);
                continue;
            }
            if (this.isNumeric(userResponse)) {
                try {
                    int numericSelection = Integer.valueOf(userResponse);
                    if (0 < numericSelection && numericSelection <= registryListing.length) {
                        String selectedRegistryKey = registryListing[numericSelection - 1];
                        if ('/' == selectedRegistryKey.charAt(selectedRegistryKey.length() - 1)) {
                            parentDirectory = String.format("%s%s", parentDirectory, registryListing[numericSelection - 1]);
                            continue;
                        }
                        String fullRegistryKey = String.format("%s%s", parentDirectory, selectedRegistryKey);
                        String value = JANOS.getRegistryString((String)fullRegistryKey, (String)"");
                        System.out.println(String.format("  %s = %s", fullRegistryKey, value));
                        if (this.isSystemKey(selectedRegistryKey)) continue;
                        System.out.print("[C]hange, [E]dit, [R]emove? ");
                        String response = this._in.readLine();
                        switch (response.toLowerCase()) {
                            case "c": {
                                this.changeRegistryKey(fullRegistryKey);
                                break;
                            }
                            case "e": {
                                this.editRegistryKey(fullRegistryKey);
                                break;
                            }
                            case "r": {
                                this.deleteRegistryKey(fullRegistryKey);
                            }
                        }
                        continue;
                    }
                    if (numericSelection != registryListing.length + 1) continue;
                    parentDirectory = this.getPreviousDirectory(parentDirectory);
                }
                catch (NumberFormatException ex) {
                    System.out.println(String.format("** '%s' invalid selection **\n", userResponse));
                }
                continue;
            }
            if ('.' == userResponse.charAt(0)) continue;
            String fullRegistryKey = String.format("%s%s", parentDirectory, userResponse);
            String value = JANOS.getRegistryString((String)fullRegistryKey, null);
            if (null == value) {
                if (0 < JANOS.getRegistryList((String)fullRegistryKey).length) {
                    parentDirectory = fullRegistryKey;
                    System.out.println("parentDirectory = " + parentDirectory);
                    continue;
                }
                System.out.print("Add Key [Y/N]? ");
                String response = this._in.readLine();
                if (!"y".equalsIgnoreCase(response)) continue;
                System.out.print("New Value(s)? ");
                value = this._in.readLine();
                value = value.trim();
                System.out.println(String.format("  %s = %s", fullRegistryKey, value));
                this.confirmNewValue(fullRegistryKey, value);
                continue;
            }
            this.editRegistryKey(userResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNumeric(String string) {
        if (null == string || 0 == string.length()) {
            return false;
        }
        Pattern pattern = NUMERIC_PATTERN;
        synchronized (pattern) {
            Matcher matcher = NUMERIC_PATTERN.matcher(string);
            return matcher.find();
        }
    }

    private String[] showContentFor(String parentDirectory, boolean showMenu) throws IOException {
        String[] registryListing = JANOS.getRegistryList((String)parentDirectory);
        if (0 < registryListing.length) {
            QuickSort<String> quickSort = new QuickSort<String>();
            quickSort.sort(registryListing, (Comparator)new StringComparer(1));
            System.out.println(String.format("\nContent of %s..", parentDirectory));
            for (int i = 0; i < registryListing.length; ++i) {
                String registryKey = registryListing[i];
                if (showMenu) {
                    System.out.print(String.format("%4d", i + 1));
                }
                if ('/' != registryKey.charAt(registryKey.length() - 1)) {
                    String fullRegistryKey = String.format("%s%s", parentDirectory, registryKey);
                    String value = JANOS.getRegistryString((String)fullRegistryKey, (String)"");
                    System.out.println(String.format("  %s = %s", registryKey, value));
                    continue;
                }
                System.out.println(String.format("  %s...", registryKey));
            }
        } else {
            String registryKey = parentDirectory;
            String value = JANOS.getRegistryString((String)registryKey, (String)"");
            System.out.println(String.format("  %s = %s", registryKey, value));
        }
        return registryListing;
    }

    private void changeRegistryKey(String fullRegistryKey) {
        System.out.print("New Value(s)? ");
        String newValue = this._in.readLine();
        if (0 < newValue.length()) {
            this.confirmNewValue(fullRegistryKey, newValue);
        }
    }

    private void editRegistryKey(String fullRegistryKey) {
        String value = JANOS.getRegistryString((String)fullRegistryKey, (String)"");
        System.out.print(String.format("\n  %s = ", fullRegistryKey));
        this._in.setValue(value);
        String newValue = this._in.readLine();
        if (0 < newValue.length() && value.length() != 0 && !value.equals(newValue)) {
            this.confirmNewValue(fullRegistryKey, newValue);
        }
    }

    private void confirmNewValue(String fullRegistryKey, String newValue) {
        try {
            newValue = newValue.trim();
            System.out.print("Accept [Y/N]? ");
            String response = this._in.readLine();
            if ("y".equalsIgnoreCase(response)) {
                JANOS.setRegistryString((String)fullRegistryKey, (String)newValue);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void deleteRegistryKey(String fullRegistryKey) {
        try {
            if (this.isSystemKey(fullRegistryKey)) {
                return;
            }
            System.out.print("Delete [Y/N]? ");
            String response = this._in.readLine();
            if ("y".equalsIgnoreCase(response)) {
                JANOS.setRegistryString((String)fullRegistryKey, (String)"");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private boolean deleteDirectory(String parentDirectory) {
        if (this.isSystemKey(parentDirectory)) {
            return false;
        }
        try {
            String[] registryListing;
            boolean removeAll;
            String prompt = String.format("Remove folder '%s' completely [Y/N]? ", parentDirectory);
            System.out.print(prompt);
            boolean bl = removeAll = 121 == this._in.read();
            if (!removeAll) {
                System.out.println("");
            }
            for (String fullRegistryKey : registryListing = this.getRegistryList(parentDirectory, removeAll)) {
                if (this.isSystemKey(fullRegistryKey)) continue;
                boolean remove = removeAll;
                if (!remove) {
                    System.out.println("");
                    prompt = String.format("Remove '%s' [Y/N]? ", fullRegistryKey);
                    System.out.print(prompt);
                    boolean bl2 = remove = 121 == this._in.read();
                }
                if (!remove) continue;
                JANOS.setRegistryString((String)fullRegistryKey, (String)"");
            }
            System.out.println("");
            return removeAll;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private String[] getRegistryList(String directory, boolean removeAll) {
        ArrayList<String> registryKeysList = new ArrayList<String>();
        ArrayList<String> foldersList = new ArrayList<String>();
        foldersList.add(directory);
        while (0 < foldersList.size()) {
            String[] registryKeys;
            directory = (String)foldersList.remove(0);
            if ('/' != directory.charAt(directory.length() - 1)) {
                directory = directory + '/';
            }
            for (String registryKey : registryKeys = JANOS.getRegistryList((String)directory)) {
                String fullRegistryKey = String.format("%s%s", directory, registryKey);
                if ('/' == registryKey.charAt(registryKey.length() - 1)) {
                    if (!removeAll) continue;
                    foldersList.add(fullRegistryKey);
                    continue;
                }
                registryKeysList.add(fullRegistryKey);
            }
        }
        return (String[])registryKeysList.toArray();
    }

    private String getPreviousDirectory(String parentDirectory) {
        int lastForwardSlashPos = parentDirectory.lastIndexOf("/", parentDirectory.length() - 2);
        if (-1 != lastForwardSlashPos) {
            parentDirectory = parentDirectory.substring(0, lastForwardSlashPos);
        }
        return parentDirectory;
    }

    private boolean isSystemKey(String fullRegistryKey) {
        return fullRegistryKey.startsWith("/$") || fullRegistryKey.startsWith("$") || fullRegistryKey.toLowerCase().startsWith("/ipconfig") || fullRegistryKey.toLowerCase().startsWith("ipconfig");
    }
}

