/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateUtils {
    public static final long MILLIS_IN_SECOND = 1000L;
    public static final long MILLIS_IN_MINUTE = 60000L;
    public static final long MILLIS_IN_HOUR = 3600000L;
    public static final long MILLIS_IN_DAY = 86400000L;
    private static final Calendar _calendar = Calendar.getInstance();
    private static final TimeZone _timezone = _calendar.getTimeZone();

    public static TimeZone getTimezone() {
        return _timezone;
    }

    public static String getTimezoneID() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("z");
        return dateFormat.format(new Date());
    }

    public static long getTimezoneOffset() {
        long timeZoneOffset = _timezone.getOffset(_calendar.get(0), _calendar.get(1), _calendar.get(2), _calendar.get(5), _calendar.get(7), (int)DateUtils.getMillisIntoDay());
        return timeZoneOffset;
    }

    public static boolean isDaylightSavings() {
        return _timezone.inDaylightTime(_calendar.getTime());
    }

    public static long getStartOfDay() {
        long now = System.currentTimeMillis();
        long startOfDay = now + (1000L - now % 1000L) - DateUtils.getMillisIntoDay();
        System.out.println("startOfDay: " + new Date(startOfDay));
        return startOfDay;
    }

    public static long getStartOfHour() {
        long startOfHour = System.currentTimeMillis() - System.currentTimeMillis() % 3600000L;
        System.out.println("startOfHour: " + new Date(startOfHour));
        return startOfHour;
    }

    public static long getStartOfMinute() {
        long startOfMinute = System.currentTimeMillis() - System.currentTimeMillis() % 60000L;
        System.out.println("startOfMinute: " + new Date(startOfMinute));
        return startOfMinute;
    }

    public static long getMillisIntoDay() {
        long millisIntoDay = _calendar.get(11) * 3600000 + _calendar.get(12) * 60000 + _calendar.get(13) * 1000;
        return millisIntoDay;
    }

    public static long getTimeInDay(int hour, int minute, int second) {
        long timeInDay = 3600000L * (long)hour + 60000L * (long)minute + 1000L * (long)second;
        System.out.println("timeInDay: " + timeInDay);
        timeInDay = DateUtils.getStartOfDay() + timeInDay;
        System.out.println("timeInDay: " + timeInDay);
        return timeInDay;
    }
}

