/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.text;

import com.integpg.janoslib.debug.DEBUG;
import com.integpg.system.ArrayUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class QuickDateFormat {
    private static final byte[][] AM_PM_STRING_BYTES = new byte[][]{"am".getBytes(), "pm".getBytes()};
    private final Calendar _calendar = Calendar.getInstance();
    private final byte[] _dateStampBytes;
    public final int DATE_STAMP_LENGTH;
    public final int DATE_STAMP_LENGTH_WITH_COMMA;
    private final String _pattern;
    int _monthPos;
    int _dayPos;
    int _2yearPos;
    int _4yearPos;
    int _hourPos;
    int _hourOfDayPos;
    int _minutePos;
    int _secondPos;
    int _millisPos;
    int _timezonePos;
    int _ampmPos;
    private final byte[] _buf = new byte[8];
    private long _lastTimeRef = 0L;
    private long _nextHour = System.currentTimeMillis() - System.currentTimeMillis() % 3600000L;
    private long _nextMinute = 0L;

    public QuickDateFormat(String pattern) {
        this._pattern = pattern;
        this._dateStampBytes = new byte[pattern.length() + 2];
        ArrayUtils.arraycopy((Object)pattern.getBytes(), (int)0, (Object)this._dateStampBytes, (int)0, (int)pattern.length());
        this._dateStampBytes[this._dateStampBytes.length - 2] = 44;
        this._dateStampBytes[this._dateStampBytes.length - 1] = 32;
        this.DATE_STAMP_LENGTH = this._dateStampBytes.length - 2;
        this.DATE_STAMP_LENGTH_WITH_COMMA = this._dateStampBytes.length;
        this._monthPos = pattern.indexOf("MM");
        this._dayPos = pattern.indexOf("dd");
        if (-1 == this._dayPos) {
            this._dayPos = pattern.indexOf("DD");
        }
        this._2yearPos = pattern.indexOf("yy");
        if (-1 == this._2yearPos) {
            this._2yearPos = pattern.indexOf("YY");
        }
        this._4yearPos = pattern.indexOf("yyyy");
        if (-1 == this._4yearPos) {
            this._4yearPos = pattern.indexOf("YYYY");
        }
        this._hourPos = pattern.indexOf("hh");
        this._hourOfDayPos = pattern.indexOf("HH");
        this._minutePos = pattern.indexOf("mm");
        this._secondPos = pattern.indexOf("ss");
        this._millisPos = pattern.indexOf("fff");
        if (-1 == this._millisPos) {
            this._millisPos = pattern.indexOf("SSS");
        }
        this._timezonePos = pattern.indexOf("zzz");
        this._ampmPos = pattern.indexOf("aa");
        this.updateTimezone();
    }

    public String getDateFormatString() {
        return this._pattern;
    }

    private void updateTimezone() {
        if (-1 != this._timezonePos) {
            long start = System.currentTimeMillis();
            SimpleDateFormat dateFormat = new SimpleDateFormat("z");
            String timezoneId = dateFormat.format(new Date());
            ArrayUtils.arraycopy((Object)timezoneId.getBytes(), (int)0, (Object)this._dateStampBytes, (int)this._timezonePos, (int)3);
            long elapsed = System.currentTimeMillis() - start;
            DEBUG.println("update timezone took: " + elapsed);
        }
    }

    public String format(Date date) {
        return this.format(date.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(long time) {
        byte[] byArray = this._dateStampBytes;
        synchronized (this._dateStampBytes) {
            if (time <= 0L) {
                time = System.currentTimeMillis();
            }
            if (this._nextHour <= time) {
                this._nextHour += 3600000L;
                this.updateTimezone();
            }
            if (this._lastTimeRef > time || time > this._nextMinute) {
                this.InitRefBytes(time);
            }
            int delta = (int)(time - this._lastTimeRef);
            int rSecond = delta / 1000;
            if (-1 != this._secondPos) {
                this.stuffInt(this._buf, rSecond + 100, 0, false);
                ArrayUtils.arraycopy((Object)this._buf, (int)1, (Object)this._dateStampBytes, (int)this._secondPos, (int)2);
            }
            if (-1 != this._millisPos) {
                int rMillis = delta - 1000 * rSecond;
                this.stuffInt(this._buf, rMillis + 1000, 0, false);
                ArrayUtils.arraycopy((Object)this._buf, (int)1, (Object)this._dateStampBytes, (int)this._millisPos, (int)3);
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return new String(this._dateStampBytes, 0, this.DATE_STAMP_LENGTH);
        }
    }

    public byte[] toByteArray() {
        return this._dateStampBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void InitRefBytes(long time) {
        this._calendar.setTimeInMillis(time);
        int rMonth = this._calendar.get(2);
        int rDay = this._calendar.get(5);
        int rYear = this._calendar.get(1);
        int rMinute = this._calendar.get(12);
        int rSecond = this._calendar.get(13);
        int rMillis = this._calendar.get(14);
        this._lastTimeRef = time - (long)(1000 * rSecond + rMillis);
        this._nextMinute = time + 60000L - time % 60000L;
        byte[] byArray = this._dateStampBytes;
        synchronized (this._dateStampBytes) {
            int rHour;
            if (-1 != this._monthPos) {
                this.stuffInt(this._buf, rMonth + 101, 0, false);
                ArrayUtils.arraycopy((Object)this._buf, (int)1, (Object)this._dateStampBytes, (int)this._monthPos, (int)2);
            }
            if (-1 != this._dayPos) {
                this.stuffInt(this._buf, rDay + 100, 0, false);
                ArrayUtils.arraycopy((Object)this._buf, (int)1, (Object)this._dateStampBytes, (int)this._dayPos, (int)2);
            }
            this.stuffInt(this._buf, rYear, 0, false);
            if (-1 != this._2yearPos) {
                ArrayUtils.arraycopy((Object)this._buf, (int)2, (Object)this._dateStampBytes, (int)this._2yearPos, (int)2);
            }
            if (-1 != this._4yearPos) {
                ArrayUtils.arraycopy((Object)this._buf, (int)0, (Object)this._dateStampBytes, (int)this._4yearPos, (int)4);
            }
            if (-1 != this._hourPos) {
                rHour = this._calendar.get(10);
                this.stuffInt(this._buf, rHour + 100, 0, false);
                ArrayUtils.arraycopy((Object)this._buf, (int)1, (Object)this._dateStampBytes, (int)this._hourPos, (int)2);
            }
            if (-1 != this._hourOfDayPos) {
                rHour = this._calendar.get(11);
                this.stuffInt(this._buf, rHour + 100, 0, false);
                ArrayUtils.arraycopy((Object)this._buf, (int)1, (Object)this._dateStampBytes, (int)this._hourOfDayPos, (int)2);
            }
            if (-1 != this._minutePos) {
                this.stuffInt(this._buf, rMinute + 100, 0, false);
                ArrayUtils.arraycopy((Object)this._buf, (int)1, (Object)this._dateStampBytes, (int)this._minutePos, (int)2);
            }
            if (-1 != this._ampmPos) {
                byte[] amPmBytes = AM_PM_STRING_BYTES[this._calendar.get(9)];
                ArrayUtils.arraycopy((Object)amPmBytes, (int)0, (Object)this._dateStampBytes, (int)this._ampmPos, (int)2);
            }
            // ** MonitorExit[var9_8] (shouldn't be in output)
            return;
        }
    }

    private void stuffInt(byte[] array, int value, int dec, boolean rjustified) {
        int dig;
        ArrayUtils.arrayFill((byte[])array, (int)0, (int)array.length, (byte)32);
        if (value == 0) {
            array[0] = 48;
            return;
        }
        int offset = 0;
        boolean leading = true;
        if (value < 0) {
            array[offset++] = 45;
            value = -value;
            rjustified = false;
        }
        for (dig = 1000000; dig >= 1; dig /= 10) {
            if (leading && value < dig) {
                if (!rjustified) continue;
                ++offset;
                continue;
            }
            array[offset] = 48;
            while (value >= dig) {
                int n = offset;
                array[n] = (byte)(array[n] + 1);
                value -= dig;
            }
            ++offset;
            leading = false;
        }
        for (dig = dec; dig > 0; --dig) {
            array[offset] = array[offset - 1];
            if (array[offset] == 32) {
                array[offset] = 48;
            }
            --offset;
            if (dig != 1) continue;
            array[offset] = 46;
            if (array[offset - 1] != 32) continue;
            array[offset - 1] = 48;
        }
    }
}

