/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.messagepumpsample;

import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.messagepumpsample.MessagePumpEngine;
import com.integpg.messagepumpsample.MessagePumpListener;
import com.integpg.messagepumpsample.RegistryMessageHandler;
import com.integpg.messagepumpsample.SystemMessageTypes;
import com.integpg.system.SystemMsg;

public class MessagePumpSampleMain
implements MessagePumpListener {
    private static final QuickDateFormat QUICK_DATE_FORMAT = new QuickDateFormat("MM-dd-yy HH:mm:ss.fff");

    public static void main(String[] args) throws InterruptedException {
        MessagePumpSampleMain msgPumpSample = new MessagePumpSampleMain();
        msgPumpSample.init();
        Thread.sleep(Integer.MAX_VALUE);
    }

    public void init() {
        MessagePumpEngine.addListener(this);
        MessagePumpEngine.addListener(new RegistryMessageHandler());
        MessagePumpEngine.start();
    }

    @Override
    public void messageReceived(SystemMsg systemMsg) {
        String dateString = QUICK_DATE_FORMAT.format(System.currentTimeMillis());
        String messageName = SystemMessageTypes.getMessageNameByType(systemMsg.type);
        System.out.println(dateString + " - Process Msg: " + messageName);
        if (0 < systemMsg.msg.length) {
            String hexDumpString = HexUtils.hexDump(systemMsg.msg);
            System.out.println(hexDumpString);
        }
    }
}

