/*
 * Decompiled with CFR 0.152.
 */
package com.integ.mqtt.externalmodules;

import com.integ.janoslib.externalmodules.FourTwentyModule;
import com.integ.mqtt.protocol.MqttClient;
import com.integ.mqtt.protocol.SubscriptionListener;
import com.integpg.janoslib.logger.AppLog;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MqttFourTwentyOutputs
implements SubscriptionListener {
    private static final Pattern OUTPUTS_PATTERN = Pattern.compile("jnior/([\\d\\w-]+)/set/fourtwenty/outputs/([\\d\\w-]+)/.*");
    private static final Pattern PERCENTAGE_PATTERN = Pattern.compile(".*/percentage");
    private final MqttClient _mqttClient;
    private final FourTwentyModule _fourTwentyModule;

    public MqttFourTwentyOutputs(MqttClient mqttClient, FourTwentyModule fourTwentyModule) {
        this._mqttClient = mqttClient;
        this._mqttClient.addSubscriptionListener(this);
        this._fourTwentyModule = fourTwentyModule;
    }

    public void report() {
    }

    @Override
    public boolean subscriptionUpdate(String topic, byte[] data) {
        String topicValue = new String(data);
        System.out.println("match " + OUTPUTS_PATTERN.pattern() + ", " + topic);
        Matcher matcher = OUTPUTS_PATTERN.matcher(topic);
        boolean found = matcher.find();
        System.out.println(OUTPUTS_PATTERN.pattern() + " matched: " + found);
        if (found) {
            String outputString = matcher.group(2);
            if (!MqttFourTwentyOutputs.isNumeric(outputString)) {
                throw new RuntimeException("error getting channel from " + topic);
            }
            int channel = Integer.parseInt(outputString);
            System.out.println(String.format("channel: 0x%d", channel));
            matcher = PERCENTAGE_PATTERN.matcher(topic);
            found = matcher.find();
            System.out.println(PERCENTAGE_PATTERN.pattern() + " matched: " + found);
            if (found) {
                try {
                    double percentage = Double.valueOf(topicValue);
                    if (0.0 > percentage || 100.0 < percentage) {
                        throw new RuntimeException("Percentage out of range for " + topic + ": " + percentage);
                    }
                    this._fourTwentyModule.setPercentageOutput(channel - 1, percentage);
                    this._fourTwentyModule.commit();
                    this.report();
                }
                catch (Exception ex) {
                    AppLog.error("error converting " + topicValue + " to a percentage", ex);
                }
            }
        }
        return false;
    }

    private static boolean isNumeric(String s) {
        boolean isNumeric = true;
        for (int j = 0; isNumeric && j < s.length(); isNumeric &= Character.isDigit(s.charAt(j)), ++j) {
        }
        return isNumeric;
    }
}

