/*
 * Decompiled with CFR 0.152.
 */
package com.integ.common.externalmodules;

import com.integ.common.externalmodules.DeviceInfo;
import com.integpg.system.ArrayUtils;
import com.integpg.system.JANOS;

public class TenVoltModule
extends DeviceInfo {
    private final double[] _scaledIns = new double[4];
    private final double[] _savedScaledIns = new double[4];
    private final double[] _scaledOuts = new double[4];
    private final double[] _savedScaledOuts = new double[4];

    public static TenVoltModule getModuleAtIndex(int moduleIndex) {
        long deviceAddress = DeviceInfo.getModuleAddressAtIndex("TypeFD", moduleIndex);
        if (-1L != deviceAddress) {
            TenVoltModule device = new TenVoltModule(deviceAddress, moduleIndex);
            return device;
        }
        return null;
    }

    public TenVoltModule(long deviceAddress, int index) {
        super(deviceAddress, index);
        this._writeBlock = new byte[4];
        this._rawIn = new int[4];
        this._rawOut = new int[2];
    }

    @Override
    public void update() {
        byte[] deviceBlock = this.read();
        if (this.Updated) {
            double scale;
            int i;
            for (i = 0; i < 4; ++i) {
                this._rawIn[i] = ArrayUtils.getShort((byte[])deviceBlock, (int)(i * 2)) & 0xFFFF;
                this._scaledIns[i] = (double)this._rawIn[i] / 65520.0 * 16.0 + 4.0;
                if (-1 == this._significantDecimalPlaces) continue;
                scale = Math.pow(10.0, this._significantDecimalPlaces);
                this._scaledIns[i] = (double)Math.round(this._scaledIns[i] * scale) / scale;
            }
            for (i = 0; i < 4; ++i) {
                if (this._savedScaledIns[i] == this._scaledIns[i]) continue;
                this._savedScaledIns[i] = this._scaledIns[i];
                System.out.println(String.format("10v In[%d] updated: " + this._precisionString, i, this._scaledIns[i]));
            }
            for (i = 0; i < 2; ++i) {
                this._rawOut[i] = ArrayUtils.getShort((byte[])deviceBlock, (int)(i * 2 + 8)) & 0xFFFF;
                this._scaledOuts[i] = (double)this._rawOut[i] / 65520.0 * 16.0 + 4.0;
                if (-1 == this._significantDecimalPlaces) continue;
                scale = Math.pow(10.0, this._significantDecimalPlaces);
                this._scaledOuts[i] = (double)Math.round(this._scaledOuts[i] * scale) / scale;
            }
            for (i = 0; i < 2; ++i) {
                if (this._savedScaledOuts[i] == this._scaledOuts[i]) continue;
                this._savedScaledOuts[i] = this._scaledOuts[i];
                System.out.println(String.format("10v Out[%d] updated: " + this._precisionString, i, this._scaledOuts[i]));
            }
        }
    }

    public double getPercentageIn(int channel) {
        int value = this.getRawIn(channel);
        double percentage = (double)value / 65520.0;
        return percentage;
    }

    public double getScaledInput(int channel) {
        String channelBaseString = String.format("Externals/%s/Ain%d", this.DeviceAddressString, channel + 1);
        System.out.println("channelBaseString: " + channelBaseString);
        double min = JANOS.getRegistryDouble((String)(channelBaseString + "/Min"), (double)0.0);
        double max = JANOS.getRegistryDouble((String)(channelBaseString + "/Max"), (double)100.0);
        double scaledValue = this.getPercentageIn(channel) * (max - min) + min;
        return scaledValue;
    }

    public double getPercentageOut(int channel) {
        int value = this.getRawOut(channel);
        double percentage = (double)value / 65520.0;
        return percentage;
    }

    public double getScaledOutput(int channel) {
        String channelBaseString = String.format("Externals/%s/Aout%d", this.DeviceAddressString, channel + 1);
        System.out.println("channelBaseString: " + channelBaseString);
        double min = JANOS.getRegistryDouble((String)(channelBaseString + "/Min"), (double)0.0);
        double max = JANOS.getRegistryDouble((String)(channelBaseString + "/Max"), (double)100.0);
        double scaledValue = this.getPercentageOut(channel) * (max - min) + min;
        return scaledValue;
    }

    public void setScaledOutput(int channel, double value) {
        String channelBaseString = String.format("Externals/%s/Aout%d", this.DeviceAddressString, channel + 1);
        double min = JANOS.getRegistryDouble((String)(channelBaseString + "/Min"), (double)0.0);
        double max = JANOS.getRegistryDouble((String)(channelBaseString + "/Max"), (double)100.0);
        double targetDelta = value - min;
        double totalDelta = max - min;
        double percentage = targetDelta / totalDelta;
        this.setRawOutput(channel, (int)(percentage * 65520.0));
    }

    public void setPercentageOutput(int channel, double percentage) {
        this.setRawOutput(channel, (int)(65520.0 * (percentage /= 100.0)));
    }

    public void setRawOutput(int channel, int value) {
        System.out.println("set output for channel " + channel + " to " + value);
        ArrayUtils.setShort((byte[])this._writeBlock, (int)(channel * 2), (short)((short)value));
    }

    public String getInputUnits(int channel) {
        String channelBaseString = String.format("Externals/%s/Ain%d", this.DeviceAddressString, channel + 1);
        String units = JANOS.getRegistryString((String)(channelBaseString + "/Units"), (String)"v");
        return units;
    }

    public String getOutputUnits(int channel) {
        String channelBaseString = String.format("Externals/%s/Aout%d", this.DeviceAddressString, channel + 1);
        String units = JANOS.getRegistryString((String)(channelBaseString + "/Units"), (String)"v");
        return units;
    }
}

