/*
 * Decompiled with CFR 0.152.
 */
package com.integ.mqtt.protocol.outgoingpackets;

import com.integ.mqtt.protocol.ControlPacketTypes;
import com.integ.mqtt.protocol.MqttBasePacket;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class MqttOutgoingPacket
extends MqttBasePacket {
    private static int OutgoingPacketIdentifier = 1;
    private final int _packetIdentifier = OutgoingPacketIdentifier++;
    protected ByteArrayOutputStream _variableByteArrayOutputStream;
    protected DataOutputStream _variableHeader;

    protected MqttOutgoingPacket() {
    }

    public int getPacketIdentifier() {
        return this._packetIdentifier;
    }

    protected abstract void build() throws IOException;

    public byte[] getPacket() throws IOException {
        this._variableByteArrayOutputStream = new ByteArrayOutputStream(128);
        this._variableHeader = new DataOutputStream(this._variableByteArrayOutputStream);
        this.build();
        return this._variableByteArrayOutputStream.toByteArray();
    }

    protected int writeString(DataOutputStream out, String string) throws IOException {
        out.writeShort(string.length());
        out.writeBytes(string);
        return string.length();
    }

    public String toString() {
        return ControlPacketTypes.getDescription(this.getPacketType());
    }
}

