package com.integ.mqtt;

import com.integpg.janoslib.externalio.TypeFE;
import com.integpg.janoslib.mqtt.MqttClient;

public class FourTwentyOutputs {

    private final MqttClient _mqttClient;
    private final TypeFE _typeFE;



    public FourTwentyOutputs(MqttClient mqttClient, TypeFE typeFE) {
        _mqttClient = mqttClient;
        _typeFE = typeFE;
    }



    public void report() {
        try {
            if (null != _mqttClient && null != _typeFE) {
                _typeFE.read();
                int index = _typeFE.TypeIndex - 1;

                for (int channel = 1; channel <= 2; channel++) {
                    _mqttClient.publish(
                            MqttMain.DEVICE_STATUS_TOPIC_PREFIX + "fourtwenty/outputs/" + (index * 2 + channel) + "/raw",
                            String.valueOf(_typeFE.RawOut[channel - 1]).getBytes());
                    _mqttClient.publish(
                            MqttMain.DEVICE_STATUS_TOPIC_PREFIX + "fourtwenty/outputs/" + (index * 2 + channel) + "/scaled",
                            String.format("%.2f %s", _typeFE.getScaledOutput(channel), _typeFE.getOutputUnits(channel)).getBytes());
                }

            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

}

