/*
 * Decompiled with CFR 0.152.
 */
package com.integ.mqtt.protocol;

import com.integ.mqtt.Lock;
import com.integ.mqtt.listeners.MqttClientNotifier;
import com.integ.mqtt.listeners.SubscriptionNotifier;
import com.integ.mqtt.listeners.UnhandledSubscriptionNotifier;
import com.integ.mqtt.protocol.ConnectOptions;
import com.integ.mqtt.protocol.QualityOfService;
import com.integ.mqtt.protocol.incomingpackets.ConnAckPacket;
import com.integ.mqtt.protocol.incomingpackets.IncomingPacketFactory;
import com.integ.mqtt.protocol.incomingpackets.MqttIncomingPacket;
import com.integ.mqtt.protocol.incomingpackets.PubRecPacket;
import com.integ.mqtt.protocol.incomingpackets.PublishReceivePacket;
import com.integ.mqtt.protocol.outgoingpackets.ConnectPacket;
import com.integ.mqtt.protocol.outgoingpackets.MqttOutgoingPacket;
import com.integ.mqtt.protocol.outgoingpackets.PingPacket;
import com.integ.mqtt.protocol.outgoingpackets.PubAckOutPacket;
import com.integ.mqtt.protocol.outgoingpackets.PubRecOutPacket;
import com.integ.mqtt.protocol.outgoingpackets.PubRelOutPacket;
import com.integ.mqtt.protocol.outgoingpackets.PublishPacket;
import com.integ.mqtt.protocol.outgoingpackets.SubscribeOptions;
import com.integ.mqtt.protocol.outgoingpackets.SubscribePacket;
import com.integ.mqtt.protocol.outgoingpackets.SubscribeTopic;
import com.integ.mqtt.protocol.outgoingpackets.UnsubscribeOptions;
import com.integ.mqtt.protocol.outgoingpackets.UnsubscribePacket;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.logging.Logger;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.system.ArrayUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Hashtable;

public class MqttClient
implements Runnable {
    public static final Logger MQTT_LOG = Logger.getLogger("/temp/mqtt_protocol.log");
    private long _connectionTime;
    private CONNECTION_STATES _state;
    private final Lock WaitToConnectLock = new Lock("WaitToConnectLock");
    private String _host = "broker.hivemq.com";
    private int _port = 1883;
    private boolean _secure = false;
    private ConnectOptions _connectOptions;
    private Socket _client;
    private OutputStream _outputStream;
    private InputStream _inputStream;
    private String _connectionInfoString;
    private boolean _gracefulClose;
    private final MqttClientNotifier _mqttClientNotifier = new MqttClientNotifier();
    private final SubscriptionNotifier _subscriptionNotifier = new SubscriptionNotifier();
    private final UnhandledSubscriptionNotifier _unhandledSubscriptionNotifier = new UnhandledSubscriptionNotifier();
    private final Hashtable<Integer, PublishPacket> _publishedTopicsByIdentifier = new Hashtable();
    private final Hashtable<String, PublishPacket> _publishedTopicMap = new Hashtable();
    private final ArrayList<SubscribeTopic> _subscribedTopics = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateState(CONNECTION_STATES newState) {
        MqttClient mqttClient = this;
        synchronized (mqttClient) {
            if (newState != this._state) {
                try {
                    throw new RuntimeException("update state to " + newState.toString());
                }
                catch (RuntimeException ex) {
                    ex.printStackTrace();
                    MQTT_LOG.info(String.format("updateState(%s)", newState.toString()));
                }
            }
            this._state = newState;
        }
    }

    public MqttClient() {
        this.updateState(CONNECTION_STATES.DISCONNECTED);
    }

    public void start() {
        Thread thd = new Thread(this);
        thd.setName(this.getClass().getName());
        thd.start();
    }

    public MqttClient setHost(String host) {
        System.out.println("set host: " + host);
        this._host = host;
        return this;
    }

    public String getHost() {
        return this._host;
    }

    public MqttClient setPort(int port) {
        System.out.println("set port: " + port);
        this._port = port;
        return this;
    }

    public MqttClient setSecure(boolean secure) {
        this._secure = secure;
        return this;
    }

    public void setConnectOptions(ConnectOptions connectOptions) {
        this._connectOptions = connectOptions;
    }

    public MqttClientNotifier getClientNotifier() {
        return this._mqttClientNotifier;
    }

    public SubscriptionNotifier getSubscriptionNotifier() {
        return this._subscriptionNotifier;
    }

    public UnhandledSubscriptionNotifier getUnhandledSubscriptionNotifier() {
        return this._unhandledSubscriptionNotifier;
    }

    public String getConnectionInfo() {
        return this._connectionInfoString;
    }

    public boolean getClosedGracefully() {
        return this._gracefulClose;
    }

    public boolean isConnected() {
        return null != this._client && this._state.ordinal() >= CONNECTION_STATES.CONNECTED.ordinal();
    }

    public boolean isConnecting() {
        return null != this._client && this._state == CONNECTION_STATES.NEGOTIATING_CONNECTION;
    }

    public boolean isConnectionAccepted() {
        return null != this._client && this._state == CONNECTION_STATES.CONNECTION_ACCEPTED;
    }

    public void connect() {
        try {
            this._mqttClientNotifier.fireConnectionAttemp();
            this._client = new Socket(this._host, this._port);
            this._inputStream = this._client.getInputStream();
            this._outputStream = this._client.getOutputStream();
            System.out.println("_client = " + this._client);
            System.out.println("_connectOptions = " + this._connectOptions);
            this._client.setSoTimeout(this._connectOptions.getKeepAliveInSeconds() * 1000);
            this._connectionInfoString = String.format("%s:%d using local port: %d", this._client.getInetAddress().toString(), this._client.getPort(), this._client.getLocalPort());
            System.out.println(this._connectionInfoString);
            this._gracefulClose = false;
            this._connectionTime = System.currentTimeMillis();
            this.updateState(CONNECTION_STATES.CONNECTED);
            this._mqttClientNotifier.fireConnectionEstablished();
        }
        catch (IOException ex) {
            this.updateState(CONNECTION_STATES.CONNECT_FAILED);
            this.close(false);
        }
        this.WaitToConnectLock.unlock();
    }

    public void close() {
        this.close(true);
    }

    public void close(boolean gracefulClose) {
        this._gracefulClose = gracefulClose;
        System.out.println("close: graceful = " + this._gracefulClose);
        try {
            if (null != this._inputStream) {
                this._inputStream.close();
            }
            if (null != this._outputStream) {
                this._outputStream.close();
            }
            if (null != this._client) {
                this._client.close();
            }
            System.out.println("is connected: " + this.isConnected());
            if (this.isConnected()) {
                this._mqttClientNotifier.fireConnectionClosed();
                this.updateState(gracefulClose ? CONNECTION_STATES.DISCONNECTED : CONNECTION_STATES.CONNECTION_LOST);
                this._publishedTopicMap.clear();
            }
            this._inputStream = null;
            this._outputStream = null;
            this._client = null;
        }
        catch (IOException ex) {
            try {
                ex.printStackTrace();
                System.out.println("is connected: " + this.isConnected());
                if (this.isConnected()) {
                    this._mqttClientNotifier.fireConnectionClosed();
                    this.updateState(gracefulClose ? CONNECTION_STATES.DISCONNECTED : CONNECTION_STATES.CONNECTION_LOST);
                    this._publishedTopicMap.clear();
                }
                this._inputStream = null;
                this._outputStream = null;
                this._client = null;
            }
            catch (Throwable throwable) {
                System.out.println("is connected: " + this.isConnected());
                if (this.isConnected()) {
                    this._mqttClientNotifier.fireConnectionClosed();
                    this.updateState(gracefulClose ? CONNECTION_STATES.DISCONNECTED : CONNECTION_STATES.CONNECTION_LOST);
                    this._publishedTopicMap.clear();
                }
                this._inputStream = null;
                this._outputStream = null;
                this._client = null;
                throw throwable;
            }
        }
    }

    public void publish(String topicName, byte[] valueBytes) throws Exception {
        this.publish(topicName, valueBytes, false);
    }

    public void publish(String topicName, byte[] valueBytes, boolean retainFlag) throws Exception {
        PublishPacket publishPacket = new PublishPacket(topicName, valueBytes);
        publishPacket.setRetainFlag(retainFlag);
        this.publish(publishPacket);
    }

    public void publish(PublishPacket publishPacket) throws Exception {
        if (!this.isConnectionAccepted()) {
            throw new RuntimeException("Connection must be Accepted");
        }
        try {
            String topicName = publishPacket.getTopicName();
            if (this._publishedTopicMap.containsKey(topicName)) {
                byte[] publishedValue = this._publishedTopicMap.get(topicName).getValue();
                byte[] newValue = publishPacket.getValue();
                if (newValue.length == publishedValue.length && ArrayUtils.arrayComp((Object)newValue, (int)0, (Object)publishedValue, (int)0, (int)newValue.length)) {
                    return;
                }
            } else {
                System.out.println(String.format("%d published topics", this._publishedTopicMap.size() + 1));
            }
            this._publishedTopicMap.put(topicName, publishPacket);
            int qosLevel = publishPacket.getQos();
            if (0 != qosLevel) {
                this._publishedTopicsByIdentifier.put(publishPacket.getPacketIdentifier(), publishPacket);
                System.out.println(String.format("Packet %d has been published with QOS level %s (%d)", publishPacket.getPacketIdentifier(), QualityOfService.getString(qosLevel), qosLevel));
                System.out.println(String.format("%d published topics", this._publishedTopicsByIdentifier.size()));
            }
            this.send(publishPacket);
        }
        catch (Exception ex) {
            MQTT_LOG.error(ex);
        }
    }

    public void subscribe(SubscribeOptions subscribeOptions) throws Exception {
        if (!this.isConnectionAccepted()) {
            throw new RuntimeException("Connection must be Accepted");
        }
        SubscribePacket subscribePacket = new SubscribePacket(subscribeOptions);
        this.send(subscribePacket);
    }

    public void unsubscribe(UnsubscribeOptions unsubscribeOptions) throws Exception {
        if (!this.isConnectionAccepted()) {
            throw new RuntimeException("Connection must be Accepted");
        }
        UnsubscribePacket unsubscribePacket = new UnsubscribePacket(unsubscribeOptions);
        this.send(unsubscribePacket);
    }

    @Override
    public void run() {
        while (true) {
            try {
                block13: while (true) {
                    System.out.println("state = " + (Object)((Object)this._state));
                    switch (this._state.ordinal()) {
                        case 0: {
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    MqttClient.this.connect();
                                }
                            }).start();
                            this.WaitToConnectLock.tryLock();
                            break;
                        }
                        case 4: {
                            this.updateState(CONNECTION_STATES.DISCONNECTED);
                            Thread.sleep(10000L);
                            break;
                        }
                        case 5: {
                            this.updateState(CONNECTION_STATES.DISCONNECTED);
                            Thread.sleep(10000L);
                            break;
                        }
                        case 1: {
                            this.sendConnectPacket();
                            break;
                        }
                        case 2: {
                            this.waitForConnAck();
                            break;
                        }
                        case 3: {
                            try {
                                MqttIncomingPacket incomingPacket = this.readPacket();
                                if (null != incomingPacket) {
                                    this.processPacket(incomingPacket);
                                    break;
                                }
                                this.send(new PingPacket());
                            }
                            catch (Exception ex) {
                                this.close(false);
                            }
                            continue block13;
                        }
                        default: {
                            Thread.sleep(1000L);
                            throw new InterruptedException((Object)((Object)this._state) + " is unhandled!");
                        }
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void waitForConnAck() {
        try {
            MqttIncomingPacket packet = this.readPacket();
            if (null != packet && packet instanceof ConnAckPacket) {
                this.updateState(CONNECTION_STATES.CONNECTION_ACCEPTED);
                long connectionAcceptedDuration = System.currentTimeMillis() - this._connectionTime;
                AppLog.info(String.format("Connection took %.2f seconds", (double)connectionAcceptedDuration / 1000.0));
                this._mqttClientNotifier.fireConnectionAccepted((ConnAckPacket)packet);
            } else {
                this.close(false);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.close(false);
        }
    }

    private void sendConnectPacket() {
        if (null == this._connectOptions) {
            throw new RuntimeException("Connection Options have not been defined");
        }
        try {
            this.updateState(CONNECTION_STATES.NEGOTIATING_CONNECTION);
            ConnectPacket connectPacket = new ConnectPacket(this._connectOptions);
            this.send(connectPacket);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.close(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(MqttOutgoingPacket controlPacket) throws Exception {
        long start = System.currentTimeMillis();
        if (!this.isConnected()) {
            throw new RuntimeException("Connection must be established");
        }
        try {
            byte[] bytes = controlPacket.getPacket();
            if (255 < bytes.length) {
                throw new Exception("Value being sent is too large");
            }
            ByteArrayOutputStream baosOut = new ByteArrayOutputStream(128);
            baosOut.write((controlPacket.getPacketType() << 4) + controlPacket.getFlags());
            int remainingLength = bytes.length;
            int encodedByte = 0;
            do {
                encodedByte = remainingLength % 128;
                if ((remainingLength /= 128) > 0) {
                    encodedByte |= 0x80;
                }
                baosOut.write(encodedByte);
            } while (remainingLength > 0);
            baosOut.write(bytes);
            byte[] outBytes = baosOut.toByteArray();
            MqttClient mqttClient = this;
            synchronized (mqttClient) {
                this._outputStream.write(outBytes);
                MQTT_LOG.info(String.format("sent %s", controlPacket.toString()));
            }
        }
        catch (Exception ex) {
            MQTT_LOG.error("error in mqtt send control packet: " + controlPacket.getClass().getName(), ex);
            this.close(false);
        }
        long sendElapsed = System.currentTimeMillis() - start;
        if (200L <= sendElapsed) {
            System.out.println("sendElapsed = " + sendElapsed);
        }
    }

    private MqttIncomingPacket readPacket() throws Exception {
        try {
            int b0 = this._inputStream.read();
            int remainingLength = this._inputStream.read();
            if (0 != (remainingLength & 0x80)) {
                this._inputStream.read();
            }
            byte[] packet = new byte[remainingLength];
            this._inputStream.read(packet, 0, remainingLength);
            int packetType = b0 >> 4;
            int packetFlags = b0 & 0xF;
            MqttIncomingPacket mqttIncommingPacket = IncomingPacketFactory.getIncomingPacketByType(packetType);
            if (null != mqttIncommingPacket) {
                mqttIncommingPacket.read(packetFlags, packet);
                MQTT_LOG.info(String.format("recv %s", mqttIncommingPacket.toString()));
            } else {
                MQTT_LOG.warn(String.format("recv UNKNOWN Packet: %d", packetType));
                MQTT_LOG.warn(String.format("%s", HexUtils.hexDump(packet)));
            }
            return mqttIncommingPacket;
        }
        catch (SocketTimeoutException ex) {
            return null;
        }
    }

    private void processPacket(MqttIncomingPacket incomingPacket) throws Exception {
        if (incomingPacket instanceof PublishReceivePacket) {
            this.processPublishPacket((PublishReceivePacket)incomingPacket);
        } else if (incomingPacket instanceof PublishReceivePacket) {
            this.processPublishPacket((PublishReceivePacket)incomingPacket);
        } else if (incomingPacket instanceof PubRecPacket) {
            this.processPubRecPacket((PubRecPacket)incomingPacket);
        } else {
            System.out.println(String.format("UNHANDLED Packet %s", incomingPacket.toString()));
        }
    }

    private void processPublishPacket(PublishReceivePacket publishReceivePacket) throws Exception {
        switch (publishReceivePacket.getQos()) {
            case 1: {
                this.send(new PubAckOutPacket(publishReceivePacket.getPacketId()));
                break;
            }
            case 2: {
                this.send(new PubRecOutPacket(publishReceivePacket.getPacketId()));
            }
        }
        boolean handled = this._subscriptionNotifier.fireSubscriptionUpdate(publishReceivePacket.getTopic(), publishReceivePacket.getPayload());
        System.out.println("handled = " + handled);
        if (!handled) {
            this._unhandledSubscriptionNotifier.fireSubscriptionUpdate(publishReceivePacket.getTopic(), publishReceivePacket.getPayload());
        }
    }

    private void processPubRecPacket(PubRecPacket pubRecPacket) throws Exception {
        this.send(new PubRelOutPacket(pubRecPacket.getPacketId()));
    }

    private static enum CONNECTION_STATES {
        DISCONNECTED,
        CONNECTED,
        NEGOTIATING_CONNECTION,
        CONNECTION_ACCEPTED,
        CONNECT_FAILED,
        CONNECTION_LOST;

    }
}

