/*
 * Decompiled with CFR 0.152.
 */
package com.integ.mqtt.externalmodules;

import com.integ.mqtt.Config;
import com.integ.mqtt.MqttMain;
import com.integ.mqtt.protocol.MqttClient;
import com.integpg.janoslib.externalio.Type28;
import java.util.Json;

public class MqttTempProbe {
    private final MqttClient _mqttClient;
    private final Type28 _tempProbeDevice;
    private final Json _json = new Json();
    private final String _tempProbeTopicPrefix;
    private final String _celsiusTopicString;
    private final String _fahrenheitTopicString;

    public MqttTempProbe(MqttClient mqttClient, Type28 tempProbeDevice) {
        this._mqttClient = mqttClient;
        this._tempProbeDevice = tempProbeDevice;
        int index = this._tempProbeDevice.TypeIndex - 1;
        int channel = index + 1;
        this._tempProbeTopicPrefix = String.format("%stempprobe/%d", MqttMain.DEVICE_STATUS_TOPIC_PREFIX, channel);
        this._celsiusTopicString = String.format("%s/celsius", this._tempProbeTopicPrefix, channel);
        this._fahrenheitTopicString = String.format("%s/fahrenheit", this._tempProbeTopicPrefix, channel);
    }

    public void report() throws Throwable {
        try {
            if (null != this._mqttClient && null != this._tempProbeDevice && this._tempProbeDevice.isPresent()) {
                this._tempProbeDevice.read();
                if (this._tempProbeDevice.hasChanged()) {
                    System.out.println("update temp probe: " + this._tempProbeDevice.AddressString);
                    int payloadFormat = Config.getPayloadFormat();
                    if (1 == payloadFormat || 3 == payloadFormat) {
                        this._mqttClient.publish(this._celsiusTopicString, String.format("%.2f C", this._tempProbeDevice.getTempC()).getBytes(), true);
                        this._mqttClient.publish(this._fahrenheitTopicString, String.format("%.2f F", this._tempProbeDevice.getTempF()).getBytes(), true);
                    }
                    if (2 == payloadFormat || 3 == payloadFormat) {
                        this.updateJson();
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void updateJson() {
        try {
            this._json.put("Celsius", (Object)String.format("%.2f C", this._tempProbeDevice.getTempC()).getBytes());
            this._json.put("Fahrenheit", (Object)String.format("%.2f F", this._tempProbeDevice.getTempF()).getBytes());
            this._mqttClient.publish(this._tempProbeTopicPrefix, this._json.toString().getBytes(), true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

