/*
 * Decompiled with CFR 0.152.
 */
package com.integ.mqtt;

import com.integ.common.logging.AppLog;
import com.integ.common.utils.FileUtils;
import com.integ.common.utils.JsonUtils;
import com.integ.common.utils.StringUtils;
import com.integ.mqtt.ConfigurationListener;
import com.integ.mqtt.MqttMain;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Json;

public class Config {
    private static final File CONFIG_FILE = new File(MqttMain.FLASH_MQTT.getPath() + "config.json");
    private static Json _json = null;
    private static final ArrayList<ConfigurationListener> _configUpdatedEventListeners = new ArrayList();
    private static final ArrayList<String> _deviceGroups = new ArrayList();
    private static Hashtable<String, Integer> _outputMasks = new Hashtable();

    public static void addConfigurationUpdatedListener(ConfigurationListener listener) {
        _configUpdatedEventListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() {
        long start;
        block5: {
            start = System.currentTimeMillis();
            try {
                if (!CONFIG_FILE.exists()) break block5;
                File file = CONFIG_FILE;
                synchronized (file) {
                    String fileContents = FileUtils.readAllText(CONFIG_FILE.getPath());
                    _json = new Json(fileContents);
                    System.out.println("Config.json: " + _json.toString());
                    Config.loadDeviceGroups();
                    Config.loadOutputMasks();
                    Config.alertListeners();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        long elapsed = System.currentTimeMillis() - start;
        AppLog.info("Loaded configuration in " + (double)elapsed / 1000.0 + " seconds");
    }

    private static void alertListeners() {
        for (ConfigurationListener listener : _configUpdatedEventListeners) {
            listener.ConfigurationUpdated();
        }
    }

    public static String getBrokerHost() {
        String host;
        Json broker;
        if (null != _json && _json.containsKey("Broker") && null != (broker = (Json)_json.get("Broker")) && !"".equals(host = broker.getString("Host"))) {
            return host;
        }
        return "";
    }

    public static int getBrokerPort() {
        if (null != _json && _json.containsKey("Broker")) {
            Json broker = (Json)_json.get("Broker");
            return JsonUtils.getInt(broker.get("Port"), 1883);
        }
        return 1883;
    }

    public static String getUsername() {
        String username;
        Json broker;
        if (null != _json && _json.containsKey("Broker") && null != (broker = (Json)_json.get("Broker")) && !"".equals(username = broker.getString("Username"))) {
            return username;
        }
        return "";
    }

    public static String getPassword() {
        String password;
        Json broker;
        if (null != _json && _json.containsKey("Broker") && null != (broker = (Json)_json.get("Broker")) && !"".equals(password = broker.getString("Password"))) {
            return password;
        }
        return "";
    }

    public static boolean getEncrypted() {
        if (null != _json && _json.containsKey("Broker")) {
            Json broker = (Json)_json.get("Broker");
            return JsonUtils.getBoolean(broker.get("Encrypted"), false);
        }
        return false;
    }

    public static String getLastWillTopic() {
        String host;
        Json lastWill;
        Json broker;
        if (null != _json && _json.containsKey("Broker") && null != (broker = (Json)_json.get("Broker")) && broker.containsKey("LastWill") && null != (lastWill = (Json)broker.get("LastWill")) && !"".equals(host = lastWill.getString("Topic"))) {
            return host;
        }
        return null;
    }

    public static String getLastWillMessage() {
        String host;
        Json lastWill;
        Json broker;
        if (null != _json && _json.containsKey("Broker") && null != (broker = (Json)_json.get("Broker")) && broker.containsKey("LastWill") && null != (lastWill = (Json)broker.get("LastWill")) && !"".equals(host = lastWill.getString("Message"))) {
            return host;
        }
        return null;
    }

    private static void loadDeviceGroups() {
        String deviceGroupsString;
        String[] groups = new String[]{};
        if (null != _json && null != (deviceGroupsString = _json.getString("DeviceGroups"))) {
            groups = StringUtils.split(deviceGroupsString, ",");
            _deviceGroups.clear();
            for (int i = 0; i < groups.length; ++i) {
                groups[i] = groups[i].trim();
                _deviceGroups.add(groups[i]);
            }
        }
    }

    public static String[] getDeviceGroups() {
        return (String[])_deviceGroups.toArray();
    }

    private static void loadOutputMasks() {
        Json[] outputGroupsJsonArray;
        if (null != _json && null != (outputGroupsJsonArray = (Json[])_json.get("OutputGroups"))) {
            _outputMasks.clear();
            for (int i = 0; i < outputGroupsJsonArray.length; ++i) {
                Json outputGroupJson = outputGroupsJsonArray[i];
                System.out.println("outputGroupJson: " + outputGroupJson);
                String groupName = outputGroupJson.getString("GroupName");
                String maskString = outputGroupJson.getString("Mask");
                int mask = 0;
                mask = maskString.startsWith("0x") ? Integer.valueOf(maskString.substring(2), 16).intValue() : Integer.valueOf(maskString).intValue();
                _outputMasks.put(groupName, mask);
            }
        }
    }

    public static int getOutputMask(String name) {
        int mask = 0;
        if (_outputMasks.containsKey(name)) {
            mask = _outputMasks.get(name);
        }
        return mask;
    }
}

