/*
 * Decompiled with CFR 0.152.
 */
package com.integ.mqtt.protocol.incomingpackets;

import com.integ.mqtt.protocol.incomingpackets.ConnAckReturnCodes;
import com.integ.mqtt.protocol.incomingpackets.MqttIncomingPacket;

public class ConnAckPacket
extends MqttIncomingPacket {
    private ConnAckReturnCodes _returnCode;
    private String _statusString = "UNKNOWN";

    public ConnAckPacket setReturnCode(ConnAckReturnCodes returnCode) {
        this._returnCode = returnCode;
        switch (returnCode) {
            case CONNECTION_ACCEPTED: {
                this._statusString = "Connection Accepted";
                break;
            }
            case INVALID_PROTOCOL_VERSION: {
                this._statusString = "The Server does not support the level of the MQTT protocol requested by the Client";
                break;
            }
            case IDENTIFIER_REJECTED: {
                this._statusString = "The Client identifier is correct UTF-8 but not allowed by the Server";
                break;
            }
            case SERVER_UNAVAILABLE: {
                this._statusString = "The Network Connection has been made but the MQTT service is unavailable";
                break;
            }
            case BAD_USERNAME_OR_PASSWORD: {
                this._statusString = "The data in the user name or password is malformed";
                break;
            }
            case NOT_AUTHORIZED: {
                this._statusString = "The Client is not authorized to connect";
                break;
            }
            default: {
                this._statusString = "FUTURE USE";
            }
        }
        return this;
    }

    public ConnAckReturnCodes getReturnCode() {
        return this._returnCode;
    }

    public String getReturnStatus() {
        return this._statusString;
    }

    @Override
    public void read(int packetFlags, byte[] packet) throws Exception {
        try {
            this.setFlags(packet[0]);
            this.setReturnCode(ConnAckReturnCodes.values()[packet[1]]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return String.format("CONN Ack - %s", this._statusString);
    }
}

