/*
 * Decompiled with CFR 0.152.
 */
package com.integ.mqtt.protocol.incomingpackets;

import com.integ.mqtt.protocol.MqttClient;
import com.integ.mqtt.protocol.incomingpackets.MqttIncomingPacket;
import com.integpg.system.ArrayUtils;

public class PublishReceivePacket
extends MqttIncomingPacket {
    private int _qosLevel;
    private String _topicName;
    private byte[] _payload;

    public int getQos() {
        return this._qosLevel;
    }

    public String getTopic() {
        return this._topicName;
    }

    public byte[] getPayload() {
        return this._payload;
    }

    @Override
    public void read(int packetFlags, byte[] packet) throws Exception {
        try {
            int dupFlag = packetFlags >> 3 & 1;
            this._qosLevel = packetFlags >> 1 & 3;
            int retain = packetFlags & 1;
            int pos = 0;
            this._topicName = this.readString(packet, pos);
            pos += this._topicName.length() + 2;
            System.out.println("_topicName = " + this._topicName);
            if (0 != (packetFlags & 6)) {
                this._packetIdentifier = ArrayUtils.getShort((byte[])packet, (int)pos);
                pos += 2;
            }
            if (packet.length > pos) {
                this._payload = new byte[packet.length - pos];
                ArrayUtils.arraycopy((Object)packet, (int)pos, (Object)this._payload, (int)0, (int)(packet.length - pos));
                pos += packet.length - pos;
            }
        }
        catch (Exception ex) {
            MqttClient.MQTT_LOG.error("Error receiving PUBLISH packet", ex);
        }
    }

    public String toString() {
        return String.format("PUBLISH packet, topic: %s = %s, packetId: %d, qos: %d", this._topicName, new String(this._payload), this._packetIdentifier, this._qosLevel);
    }
}

