/*
 * Decompiled with CFR 0.152.
 */
package com.integ.mqtt;

import com.integ.common.externalmodules.EnvironSensorDevice;
import com.integ.common.externalmodules.FourTwentyModule;
import com.integ.common.externalmodules.TempProbeDevice;
import com.integ.common.externalmodules.TenVoltModule;
import com.integ.common.iolog.DigitalInputsIoLogMonitor;
import com.integ.common.iolog.RelayOutputsIoLogMonitor;
import com.integ.common.logging.AppLog;
import com.integ.common.logging.Logger;
import com.integ.common.logging.RollingFileLog;
import com.integ.common.messagepump.MessagePumpAppHandler;
import com.integ.common.messagepump.MessagePumpEngine;
import com.integ.common.net.BytesReceivedEvent;
import com.integ.common.system.Application;
import com.integ.common.system.UnitConfig;
import com.integ.mqtt.AssemblyInfo;
import com.integ.mqtt.Config;
import com.integ.mqtt.ConfigurationListener;
import com.integ.mqtt.DigitalInputs;
import com.integ.mqtt.MqttSystemMessage;
import com.integ.mqtt.RelayOutputs;
import com.integ.mqtt.externalmodules.EnvironSensor;
import com.integ.mqtt.externalmodules.FourTwentyInputs;
import com.integ.mqtt.externalmodules.FourTwentyOutputs;
import com.integ.mqtt.externalmodules.TempProbe;
import com.integ.mqtt.externalmodules.TenVoltInputs;
import com.integ.mqtt.externalmodules.TenVoltOutputs;
import com.integ.mqtt.messagehandlers.ConfigUpdatedEventHandler;
import com.integ.mqtt.messagehandlers.ConnectEventHandler;
import com.integ.mqtt.messagehandlers.DisconnectEventHandler;
import com.integ.mqtt.messagehandlers.GetStatusEventHandler;
import com.integ.mqtt.messagehandlers.PublishEventHandler;
import com.integ.mqtt.messages.ApplicationExitMessage;
import com.integ.mqtt.protocol.ConnAckPacket;
import com.integ.mqtt.protocol.ConnAckReturnCodes;
import com.integ.mqtt.protocol.ConnectOptions;
import com.integ.mqtt.protocol.ConnectionAcknowledgedEventObject;
import com.integ.mqtt.protocol.MqttClient;
import com.integ.mqtt.protocol.MqttClientListener;
import com.integ.mqtt.protocol.QualityOfService;
import com.integ.mqtt.protocol.SubscribeOptions;
import com.integ.mqtt.protocol.SubscribeTopic;
import com.integ.mqtt.protocol.SubscriptionListener;
import com.integ.mqtt.protocol.UnhandledSubscriptionListener;
import com.integ.mqtt.protocol.UnsubscribeOptions;
import com.integ.registry.RegistryListener;
import com.integ.registry.RegistryUpdateHandler;
import com.integpg.system.JANOS;
import java.io.File;
import java.text.QuickDateFormat;
import java.util.ArrayList;
import java.util.EventObject;

public class MqttMain
implements MqttClientListener,
SubscriptionListener,
UnhandledSubscriptionListener,
RegistryListener,
ConfigurationListener {
    private static final Logger UNHANDLED_SUBSCRIPTION_LOGGER = RollingFileLog.getLogger(Application.getAppName() + "_unhandledsubscriptions.log");
    public static final File FLASH_MQTT = new File("/flash/mqtt/");
    public static final String DEVICE_STATUS_TOPIC_PREFIX = "jnior/" + JANOS.getSerialNumber() + "/status/";
    public static final String DEVICE_SET_TOPIC_PREFIX = "jnior/" + JANOS.getSerialNumber() + "/set/";
    public static final QuickDateFormat CONNECTION_DATE_FORMAT = new QuickDateFormat("MM/dd/yyyy HH:mm:ss");
    private static MqttMain MAIN;
    public MqttClient MqttClient = null;
    private String _savedHostname;
    private final ArrayList<FourTwentyInputs> _fourTwentyInputs = new ArrayList();
    private final ArrayList<FourTwentyOutputs> _fourTwentyOutputs = new ArrayList();
    private final ArrayList<TenVoltInputs> _tenVoltInputs = new ArrayList();
    private final ArrayList<TenVoltOutputs> _tenVoltOutputs = new ArrayList();
    private final ArrayList<TempProbe> _tempProbes = new ArrayList();
    private final ArrayList<EnvironSensor> _environSensors = new ArrayList();
    private RelayOutputs _relayOutputs;
    private DigitalInputs _digitalInputs;
    private boolean _successfullyConnected;
    private final ArrayList<String> _savedDeviceGroups = new ArrayList();

    public static void main(String[] args) throws InterruptedException {
        Application.init(new AssemblyInfo());
        MAIN = new MqttMain();
        MAIN.init();
        Application.enableApplicationWatchdog(0);
        MAIN.loop();
    }

    public static MqttMain getInstance() {
        return MAIN;
    }

    public void init() throws InterruptedException {
        if (!FLASH_MQTT.exists()) {
            FLASH_MQTT.mkdir();
        }
        Config.addConfigurationUpdatedListener(this);
        Config.load();
        MessagePumpEngine.start();
        this.MqttClient = new MqttClient();
        this.reportConnectionStatus();
        this._digitalInputs = new DigitalInputs(this.MqttClient);
        DigitalInputsIoLogMonitor inputMonitor = new DigitalInputsIoLogMonitor();
        inputMonitor.addIoChannelLogEventListener(this._digitalInputs);
        inputMonitor.start();
        this._relayOutputs = new RelayOutputs(this.MqttClient);
        RelayOutputsIoLogMonitor outputMonitor = new RelayOutputsIoLogMonitor();
        outputMonitor.addIoChannelLogEventListener(this._relayOutputs);
        outputMonitor.start();
        this.loadFourToTwentyDevices();
        this.loadTenVoltDevices();
        this.loadTemperatureProbeDevices();
        this.loadEnvironmentalDevices();
        RegistryUpdateHandler registryUpdateHandler = new RegistryUpdateHandler();
        registryUpdateHandler.addRegistryListener(this);
        registryUpdateHandler.addRegistryListener(this._digitalInputs);
        registryUpdateHandler.addRegistryListener(this._relayOutputs);
        MessagePumpEngine.addListener(registryUpdateHandler);
        MessagePumpAppHandler mqttAppListener = new MessagePumpAppHandler(1600).addCommandListener("get-status", new GetStatusEventHandler()).addCommandListener("config-updated", new ConfigUpdatedEventHandler()).addCommandListener("connect", new ConnectEventHandler()).addCommandListener("disconnect", new DisconnectEventHandler()).addCommandListener("publish", new PublishEventHandler()).addCommandListener("subscribe", new PublishEventHandler());
        MessagePumpEngine.addListener(mqttAppListener);
        this.MqttClient.addConnectionListener(this);
        this.MqttClient.addSubscriptionListener(this);
        this.MqttClient.setUnhandledSubscriptionListener(this);
        while (true) {
            try {
                this.MqttClient.connect();
                if (this.MqttClient.isConnectionAccepted()) {
                    break;
                }
            }
            catch (Exception ex) {
                AppLog.error("Unable to connect", ex);
            }
            Thread.sleep(10000L);
        }
    }

    private void loadFourToTwentyDevices() {
        for (int i = 0; i < 2; ++i) {
            FourTwentyModule fourTwentyModule = FourTwentyModule.getModuleAtIndex(i + 1);
            System.out.println("four twenty device: " + fourTwentyModule);
            if (null == fourTwentyModule) continue;
            System.out.println(String.format("four twenty device: %s", fourTwentyModule.DeviceAddressString));
            this._fourTwentyInputs.add(new FourTwentyInputs(this.MqttClient, fourTwentyModule));
            this._fourTwentyOutputs.add(new FourTwentyOutputs(this.MqttClient, fourTwentyModule));
        }
    }

    private void loadTenVoltDevices() {
        for (int i = 0; i < 2; ++i) {
            TenVoltModule tenVoltModule = TenVoltModule.getModuleAtIndex(i + 1);
            System.out.println("ten volt device: " + tenVoltModule);
            if (null == tenVoltModule) continue;
            System.out.println(String.format("ten volt device: %s", tenVoltModule.DeviceAddressString));
            this._tenVoltInputs.add(new TenVoltInputs(this.MqttClient, tenVoltModule));
            this._tenVoltOutputs.add(new TenVoltOutputs(this.MqttClient, tenVoltModule));
        }
    }

    private void loadTemperatureProbeDevices() {
        for (int i = 0; i < 2; ++i) {
            TempProbeDevice tempProbeDevice = TempProbeDevice.getModuleAtIndex(i + 1);
            System.out.println("temp probe device: " + tempProbeDevice);
            if (null == tempProbeDevice) continue;
            System.out.println(String.format("temp probe device: %s", tempProbeDevice.DeviceAddressString));
            this._tempProbes.add(new TempProbe(this.MqttClient, tempProbeDevice));
        }
    }

    private void loadEnvironmentalDevices() {
        for (int i = 0; i < 2; ++i) {
            EnvironSensorDevice environSensorDevice = EnvironSensorDevice.getModuleAtIndex(i + 1);
            System.out.println("environ sensor device: " + environSensorDevice);
            if (null == environSensorDevice) continue;
            System.out.println(String.format("environ sensor device: %s", environSensorDevice.DeviceAddressString));
            this._environSensors.add(new EnvironSensor(this.MqttClient, environSensorDevice));
        }
    }

    public void loop() throws InterruptedException {
        while (true) {
            Thread.sleep(10000L);
            try {
                this.MqttClient.sendPing();
                for (FourTwentyInputs fourTwentyInputs : this._fourTwentyInputs) {
                    fourTwentyInputs.report();
                }
                for (FourTwentyOutputs fourTwentyOutputs : this._fourTwentyOutputs) {
                    fourTwentyOutputs.report();
                }
                for (TenVoltInputs tenVoltInputs : this._tenVoltInputs) {
                    tenVoltInputs.report();
                }
                for (TenVoltOutputs tenVoltOutputs : this._tenVoltOutputs) {
                    tenVoltOutputs.report();
                }
                for (TempProbe tempProbes : this._tempProbes) {
                    tempProbes.report();
                }
                for (EnvironSensor environSensor : this._environSensors) {
                    environSensor.report();
                }
            }
            catch (Exception ex) {
                AppLog.error("error in mqtt main loop", ex);
            }
            Thread.sleep(5000L);
        }
    }

    @Override
    public boolean subscriptionUpdate(String topic, byte[] data) {
        if (topic.endsWith("set-hostname")) {
            String message = new String(data);
            AppLog.info("setting hostname to " + message);
            JANOS.setRegistryString((String)"IpConfig/Hostname", (String)message);
            return true;
        }
        return false;
    }

    @Override
    public void connectionEstablished(EventObject evt) {
        AppLog.info("Connected to mqtt broker: " + this.MqttClient.getConnectionInfo());
        JANOS.setRegistryString((String)"AppData/MQTT/ConnectionEstablishedTime", (String)CONNECTION_DATE_FORMAT.format(System.currentTimeMillis()));
        this.reportConnectionStatus();
        this._successfullyConnected = true;
    }

    @Override
    public void connectionAknowledged(ConnectionAcknowledgedEventObject evt) {
        ConnAckPacket connAckPacket = evt.getConnAckPacket();
        if (null != connAckPacket) {
            System.out.println("connAckPacket: " + connAckPacket);
            ConnAckReturnCodes returnCode = connAckPacket.getReturnCode();
            AppLog.info("returnCode: " + (Object)((Object)returnCode));
            this.reportConnectionStatus();
            if (returnCode == ConnAckReturnCodes.CONNECTION_ACCEPTED) {
                try {
                    String hostname;
                    this.MqttClient.publish(DEVICE_STATUS_TOPIC_PREFIX + "hostname", UnitConfig.getHostname().getBytes(), true);
                    this._savedHostname = hostname = UnitConfig.getHostname();
                    SubscribeOptions subscribeOptions = new SubscribeOptions().addTopic(new SubscribeTopic("jnior/" + UnitConfig.SERIAL_NUMBER + "/set/#", QualityOfService.AT_LEAST_ONCE)).addTopic(new SubscribeTopic("jnior/" + hostname.toLowerCase() + "/set/#", QualityOfService.AT_LEAST_ONCE)).addTopic(new SubscribeTopic("jnior/" + UnitConfig.SERIAL_NUMBER + "/custom/#", QualityOfService.AT_LEAST_ONCE)).addTopic(new SubscribeTopic("jnior/" + hostname.toLowerCase() + "/custom/#", QualityOfService.AT_LEAST_ONCE));
                    this.MqttClient.subscribe(subscribeOptions);
                    this.updateDeviceNameSubscription();
                }
                catch (Exception ex) {
                    AppLog.error("error in connection acknowledged", ex);
                }
                this._digitalInputs.reportCurrentStates();
                this._relayOutputs.reportCurrentStates();
            }
        }
    }

    @Override
    public void connectionClosed(EventObject evt) {
        System.out.println("connection closed");
        JANOS.setRegistryString((String)"AppData/MQTT/ConnectionLostTime", (String)CONNECTION_DATE_FORMAT.format(System.currentTimeMillis()));
        this.reportConnectionStatus();
        if (this._successfullyConnected && !this.MqttClient.getClosedGracefully()) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (!MqttMain.this.MqttClient.isConnectionAccepted()) {
                        try {
                            MqttMain.this.MqttClient.connect();
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }, "mqtt-reconnection");
            thread.setDaemon(false);
            thread.start();
        }
    }

    @Override
    public void bytesReceived(BytesReceivedEvent evt) {
    }

    @Override
    public void registryKeyUpdated(String registryKeyName) {
        if ("ipconfig/hostname".equalsIgnoreCase(registryKeyName)) {
            try {
                String hostname = UnitConfig.getHostname();
                AppLog.info("old hostname: " + this._savedHostname);
                UnsubscribeOptions unsubscribeOptions = new UnsubscribeOptions().addTopic("jnior/" + this._savedHostname.toLowerCase() + "/set/#").addTopic("jnior/" + this._savedHostname.toLowerCase() + "/custom/#");
                this.MqttClient.unsubscribe(unsubscribeOptions);
                AppLog.info("new hostname: " + UnitConfig.getHostname());
                SubscribeOptions subscribeOptions = new SubscribeOptions().addTopic(new SubscribeTopic("jnior/" + hostname.toLowerCase() + "/set/#", QualityOfService.AT_LEAST_ONCE)).addTopic(new SubscribeTopic("jnior/" + hostname.toLowerCase() + "/custom/#", QualityOfService.AT_LEAST_ONCE));
                this.MqttClient.subscribe(subscribeOptions);
                this.MqttClient.publish(DEVICE_STATUS_TOPIC_PREFIX + "hostname", hostname.getBytes(), true);
                this._savedHostname = hostname;
            }
            catch (Exception ex) {
                AppLog.error("error handling registry key update for " + registryKeyName + " in MqttMain", ex);
            }
        }
    }

    @Override
    public void connectionAttempt(EventObject evt) {
        String host = Config.getBrokerHost();
        int port = Config.getBrokerPort();
        boolean secure = Config.getEncrypted();
        System.out.println(String.format("host: %s, port: %d, secure: %s", host, port, String.valueOf(secure)));
        if (!"".equalsIgnoreCase(host)) {
            String lastWillMessage;
            this.MqttClient.setHost(host).setPort(port).setSecure(secure);
            String lastWillTopic = Config.getLastWillTopic();
            if (null == lastWillTopic || "".equals(lastWillTopic)) {
                lastWillTopic = "jnior/" + JANOS.getSerialNumber() + "/LastWill";
            }
            if (null == (lastWillMessage = Config.getLastWillMessage()) || "".equals(lastWillMessage)) {
                lastWillMessage = "Has disconnected";
            }
            ConnectOptions connectOptions = new ConnectOptions("jr" + JANOS.getSerialNumber());
            connectOptions.setCleanConnection(true).setUsername(Config.getUsername()).setPassword(Config.getPassword()).setKeepAliveSeconds(900).setWillTopic(lastWillTopic).setWillMessage(lastWillMessage).setWillQos(0).setWillRetain(Boolean.FALSE);
            this.MqttClient.setConnectOptions(connectOptions);
        }
    }

    @Override
    public void ConfigurationUpdated() {
        try {
            if (null != this.MqttClient && !Config.getBrokerHost().equalsIgnoreCase(this.MqttClient.getHost())) {
                this.MqttClient.close();
            }
            this.updateDeviceNameSubscription();
        }
        catch (Exception ex) {
            AppLog.error("error in configuration listener", ex);
        }
    }

    @Override
    public void unhandledSubscriptionUpdate(String topic, byte[] data) {
        try {
            UNHANDLED_SUBSCRIPTION_LOGGER.info("topic " + topic + " has not been handled");
            String message = new String(data);
            MqttSystemMessage msg = new MqttSystemMessage("unhandled-topic").put("Topic", topic).put("Payload", message);
            MessagePumpEngine.postMessage(msg.getSystemMsg());
        }
        catch (Exception ex) {
            AppLog.error("error in unhandled subscription handler", ex);
        }
    }

    private void updateDeviceNameSubscription() throws Exception {
        try {
            if (null != this.MqttClient) {
                String[] mqttGroups = Config.getDeviceGroups();
                if (0 < this._savedDeviceGroups.size()) {
                    UnsubscribeOptions unsubscribeOptions = new UnsubscribeOptions();
                    for (String savedMqttGroup : this._savedDeviceGroups) {
                        String topicName = "jnior/" + savedMqttGroup.toLowerCase() + "/set/#";
                        AppLog.info("unsubscribe from " + topicName);
                        unsubscribeOptions.addTopic(topicName);
                        topicName = "jnior/" + savedMqttGroup.toLowerCase() + "/custom/#";
                        AppLog.info("unsubscribe from " + topicName);
                        unsubscribeOptions.addTopic(topicName);
                    }
                    this.MqttClient.unsubscribe(unsubscribeOptions);
                }
                SubscribeOptions subscribeOptions = new SubscribeOptions();
                for (String string : mqttGroups) {
                    String topicName = "jnior/" + string.toLowerCase() + "/set/#";
                    AppLog.info("subscribe to " + topicName);
                    subscribeOptions.addTopic(new SubscribeTopic(topicName, QualityOfService.AT_LEAST_ONCE));
                    topicName = "jnior/" + string.toLowerCase() + "/custom/#";
                    AppLog.info("subscribe to " + topicName);
                    subscribeOptions.addTopic(new SubscribeTopic(topicName, QualityOfService.AT_LEAST_ONCE));
                }
                this.MqttClient.subscribe(subscribeOptions);
                this._savedDeviceGroups.clear();
                for (String string : mqttGroups) {
                    this._savedDeviceGroups.add(string);
                }
            }
        }
        catch (Exception ex) {
            AppLog.error("error in device name subscription handler", ex);
        }
    }

    public void reportConnectionStatus() {
        MqttSystemMessage msg = new MqttSystemMessage("current-status").put("ConnectionStatus", this.MqttClient.isConnectionAccepted()).put("ConnectionInfo", this.MqttClient.getConnectionInfo());
        System.out.println(String.format("ConnectionStatus: %s", msg.getJson().toString()));
        MessagePumpEngine.postMessage(msg.getSystemMsg());
    }

    protected void finalize() {
        AppLog.info(this.getClass().getName() + " finalized");
        ApplicationExitMessage applicationInfoMessage = new ApplicationExitMessage();
        MessagePumpEngine.postMessage(applicationInfoMessage.build());
    }
}

