/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.externalio;

import com.integpg.janoslib.externalio.ExternalModule;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.utils.ExternalUtils;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.sensor.SensorPort;
import com.integpg.system.ArrayUtils;
import java.io.IOException;

public class Type7E
extends ExternalModule {
    private static final Type7E NULL_DEVICE = new Type7E(0L);
    private static final int START_ADDR = 32;
    private static final int LENGTH = 32;
    private final byte[] _data;
    private double _tempC = Double.NaN;
    private double _tempF = Double.NaN;
    private double _heatIndexC = Double.NaN;
    private double _heatIndexF = Double.NaN;
    private double _dewPointC = Double.NaN;
    private double _dewPointF = Double.NaN;
    private double _humidity = Double.NaN;
    private double _pressureMillibars = Double.NaN;
    private double _pressureInHg = Double.NaN;
    private int _lightLux = -1;
    private boolean _lastReadResult = true;
    public boolean Updated = false;
    private static final byte[] _initData = new byte[32];

    public static Type7E getByIndex(int index) throws IOException {
        return Type7E.getByNumber(index + 1);
    }

    public static Type7E getByNumber(int number) throws IOException {
        String deviceAddressString = ExternalUtils.getDeviceAddressFor("7e", number);
        if (!CACHED_DEVICES.containsKey(deviceAddressString)) {
            long address = HexUtils.parseHexAsLong(deviceAddressString);
            CACHED_DEVICES.put(deviceAddressString, new Type7E(address, number));
        }
        return (Type7E)CACHED_DEVICES.get(deviceAddressString);
    }

    Type7E(long address) {
        super(address, -1, "Type7E");
        this._data = new byte[30];
    }

    Type7E(long address, int index) {
        super(address, index, "Type7E");
        this._data = new byte[30];
    }

    @Override
    public boolean hasChanged() {
        return this.Updated;
    }

    @Override
    public long getMinReadInterval() {
        return 1000L;
    }

    public boolean getLastReadResult() {
        return this._lastReadResult;
    }

    public double getTempC() {
        return this._tempC;
    }

    public double getTempF() {
        return this._tempF;
    }

    public double getHeatIndexF() {
        return this._heatIndexF;
    }

    public double getHumidity() {
        return this._humidity;
    }

    public double getPressureInHg() {
        return this._pressureInHg;
    }

    public double getLightLux() {
        return this._lightLux;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read() throws IOException {
        Type7E type7E = NULL_DEVICE;
        synchronized (type7E) {
            long now = System.currentTimeMillis();
            long readDelta = now - this.LastReadTime;
            System.out.println("readDelta = " + readDelta);
            if (readDelta < 2000L) {
                return;
            }
            this.LastReadTime = now;
            byte[] data = new byte[35];
            int id = -1;
            data[0] = -16;
            data[1] = 32;
            data[2] = 0;
            ArrayUtils.arraycopy((Object)_initData, (int)0, (Object)data, (int)3, (int)32);
            SensorPort sensorPort = SENSOR_PORT_LOCK;
            synchronized (sensorPort) {
                try {
                    SENSOR_PORT_LOCK.open();
                    SENSOR_PORT_LOCK.select(this.Address);
                    SENSOR_PORT_LOCK.data(data, 0, data.length);
                }
                catch (Exception ex) {
                    this._lastReadResult = false;
                    AppLog.error(ex);
                }
                finally {
                    try {
                        SENSOR_PORT_LOCK.close();
                    }
                    catch (Exception exception) {}
                }
                this.LastReadTime = System.currentTimeMillis();
                id = data[3] & 0xFF;
                if (255 == id) {
                    this.Updated = this._lastReadResult;
                    this._lastReadResult = false;
                } else {
                    this._lastReadResult = true;
                }
                this.Updated = !ArrayUtils.arrayComp((Object)data, (int)5, (Object)this._data, (int)0, (int)30);
                ArrayUtils.arraycopy((Object)data, (int)5, (Object)this._data, (int)0, (int)30);
            }
            if (this.Updated) {
                AppLog.info("Type7E: " + HexUtils.bytesToHex(data));
                this._tempC = (short)this.getValue(0, 2);
                this._tempC = -2.147483648E9 != this._tempC ? (this._tempC /= 16.0) : Double.NaN;
                if (-20.0 > this._tempC || 85.0 < this._tempC) {
                    AppLog.warn("Environ data: " + HexUtils.bytesToHex(data));
                    throw new RuntimeException("celcius temperature out of range: " + this._tempC);
                }
                this._tempF = -2.147483648E9 != this._tempC ? this._tempC * 9.0 / 5.0 + 32.0 : Double.NaN;
                if (101 == id || 104 == id) {
                    double humidity = this.getValue(2, 2);
                    humidity = -2.147483648E9 != humidity ? (humidity /= 16.0) : Double.NaN;
                    this._humidity = humidity;
                    if (this._humidity > 100.0 || this._humidity < 0.0) {
                        AppLog.warn("Environ data: " + HexUtils.bytesToHex(data));
                        throw new RuntimeException("humidity out of range: " + this._humidity);
                    }
                    this._dewPointC = (short)this.getValue(4, 2);
                    this._dewPointC = -2.147483648E9 != this._dewPointC ? (this._dewPointC /= 16.0) : Double.NaN;
                    this._dewPointF = -2.147483648E9 != this._dewPointC ? this._dewPointC * 9.0 / 5.0 + 32.0 : Double.NaN;
                    double humIndexC = this.getValue(6, 2);
                    humIndexC = -2.147483648E9 != humIndexC ? (humIndexC /= 16.0) : Double.NaN;
                    this._heatIndexC = this.getValue(8, 2);
                    if (-2.147483648E9 != this._heatIndexC) {
                        this._heatIndexC /= 16.0;
                    }
                    this._heatIndexF = this._heatIndexC;
                    if (-2.147483648E9 != this._heatIndexC) {
                        this._heatIndexF = this._heatIndexC * 9.0 / 5.0 + 32.0;
                    }
                }
                if (102 == id || 104 == id) {
                    this._pressureMillibars = (double)this.getValue(10, 3) / 2048.0;
                    this._pressureInHg = this.getValue(13, 3);
                    if (-2.147483648E9 != this._pressureInHg) {
                        this._pressureInHg /= 2048.0;
                    }
                }
                if (103 == id || 104 == id) {
                    this._lightLux = this.getValue(16, 3);
                }
            }
        }
    }

    @Override
    public void commit() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void printValues() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private int getValue(int idx, int len) {
        int value = 0;
        boolean invalid = true;
        while (len-- > 0) {
            value <<= 8;
            int b = this._data[idx + len] & 0xFF;
            invalid &= b == 255;
            value += b;
        }
        if (invalid) {
            value = Integer.MIN_VALUE;
        }
        return value;
    }

    public static Object get(int channel, String fieldName) {
        try {
            int index = channel - 1;
            Type7E device = Type7E.getByIndex(index);
            if (null != device) {
                device.read();
                return device.get(fieldName);
            }
            throw new RuntimeException("Environmental Sensor not present for index " + index);
        }
        catch (IOException ex) {
            throw new RuntimeException("Error getting value for Type7E." + fieldName, ex);
        }
    }

    @Override
    public Object get(String fieldName) {
        if (!this._lastReadResult) {
            return Double.NaN;
        }
        if (0 == this.TypeIndex) {
            throw new RuntimeException("Module must have an index");
        }
        if ("c".equalsIgnoreCase(fieldName) || "celsius".equalsIgnoreCase(fieldName) || "tempc".equalsIgnoreCase(fieldName)) {
            return this.getTempC();
        }
        if ("f".equalsIgnoreCase(fieldName) || "fahrenheit".equalsIgnoreCase(fieldName) || "tempf".equalsIgnoreCase(fieldName)) {
            return this.getTempF();
        }
        if ("h".equalsIgnoreCase(fieldName) || "hum".equalsIgnoreCase(fieldName) || "humidity".equalsIgnoreCase(fieldName)) {
            return this.getHumidity();
        }
        if ("heatindexf".equalsIgnoreCase(fieldName)) {
            return this.getHeatIndexF();
        }
        if ("pressurehg".equalsIgnoreCase(fieldName)) {
            return this.getPressureInHg();
        }
        if ("lux".equalsIgnoreCase(fieldName)) {
            return this.getLightLux();
        }
        throw new RuntimeException("Invalid Field Name: " + fieldName);
    }

    static {
        for (int n = 0; n < 32; ++n) {
            Type7E._initData[n] = -1;
        }
    }
}

