/*
 * Decompiled with CFR 0.152.
 */
package com.integ.mqtt.externalmodules;

import com.integ.mqtt.MqttMain;
import com.integ.mqtt.protocol.MqttClient;
import com.integpg.janoslib.externalio.TypeFD;

public class MqttTenVoltInputs {
    private final MqttClient _mqttClient;
    private final TypeFD _tenVoltModule;

    public MqttTenVoltInputs(MqttClient mqttClient, TypeFD tenVoltModule) {
        this._mqttClient = mqttClient;
        this._tenVoltModule = tenVoltModule;
    }

    public void report() {
        try {
            if (null != this._mqttClient && null != this._tenVoltModule && this._tenVoltModule.isPresent()) {
                this._tenVoltModule.read();
                System.out.println(String.format("typeIndex: %d", this._tenVoltModule.TypeIndex));
                int index = this._tenVoltModule.TypeIndex - 1;
                for (int channel = 1; channel <= 4; ++channel) {
                    this._mqttClient.publish(MqttMain.DEVICE_STATUS_TOPIC_PREFIX + "tenvolt/inputs/" + (index * 4 + channel) + "/raw", String.valueOf(this._tenVoltModule.getRawIn(channel - 1)).getBytes(), true);
                    this._mqttClient.publish(MqttMain.DEVICE_STATUS_TOPIC_PREFIX + "tenvolt/inputs/" + (index * 4 + channel) + "/percentage", String.valueOf(this._tenVoltModule.getPercentageInput(channel - 1)).getBytes(), true);
                    this._mqttClient.publish(MqttMain.DEVICE_STATUS_TOPIC_PREFIX + "tenvolt/inputs/" + (index * 4 + channel) + "/scaled", String.format("%.2f %s", this._tenVoltModule.getScaledInput(channel - 1), this._tenVoltModule.getInputUnits(channel)).getBytes(), true);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

