/*
 * Decompiled with CFR 0.152.
 */
package com.integ.mqtt;

import com.integ.mqtt.AssemblyInfo;
import com.integ.mqtt.Config;
import com.integ.mqtt.ConfigurationListener;
import com.integ.mqtt.DigitalInputs;
import com.integ.mqtt.MqttSystemMessage;
import com.integ.mqtt.RelayOutputs;
import com.integ.mqtt.externalmodules.MqttEnvironSensor;
import com.integ.mqtt.externalmodules.MqttFourTwentyInputs;
import com.integ.mqtt.externalmodules.MqttFourTwentyOutputs;
import com.integ.mqtt.externalmodules.MqttTempProbe;
import com.integ.mqtt.externalmodules.MqttTenVoltInputs;
import com.integ.mqtt.externalmodules.MqttTenVoltOutputs;
import com.integ.mqtt.messagehandlers.ConfigUpdatedEventHandler;
import com.integ.mqtt.messagehandlers.ConnectEventHandler;
import com.integ.mqtt.messagehandlers.DisconnectEventHandler;
import com.integ.mqtt.messagehandlers.GetStatusEventHandler;
import com.integ.mqtt.messagehandlers.PublishEventHandler;
import com.integ.mqtt.protocol.ConnAckPacket;
import com.integ.mqtt.protocol.ConnAckReturnCodes;
import com.integ.mqtt.protocol.ConnectOptions;
import com.integ.mqtt.protocol.ConnectionAcknowledgedEventObject;
import com.integ.mqtt.protocol.MqttClient;
import com.integ.mqtt.protocol.MqttClientListener;
import com.integ.mqtt.protocol.QualityOfService;
import com.integ.mqtt.protocol.SubscribeOptions;
import com.integ.mqtt.protocol.SubscribeTopic;
import com.integ.mqtt.protocol.SubscriptionListener;
import com.integ.mqtt.protocol.UnhandledSubscriptionListener;
import com.integ.mqtt.protocol.UnsubscribeOptions;
import com.integ.registry.RegistryListener;
import com.integ.registry.RegistryUpdateHandler;
import com.integpg.janoslib.externalio.ExternalDeviceFactory;
import com.integpg.janoslib.externalio.ExternalDeviceOrder;
import com.integpg.janoslib.externalio.ExternalModule;
import com.integpg.janoslib.externalio.Type28;
import com.integpg.janoslib.externalio.Type7E;
import com.integpg.janoslib.externalio.TypeFD;
import com.integpg.janoslib.externalio.TypeFE;
import com.integpg.janoslib.iolog.DigitalInputsIoLogMonitor;
import com.integpg.janoslib.iolog.DigitalOutputsIoLogMonitor;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.logging.Logger;
import com.integpg.janoslib.messagepump.MessagePumpAppHandler;
import com.integpg.janoslib.messagepump.MessagePumpEngine;
import com.integpg.janoslib.net.BytesReceivedEvent;
import com.integpg.janoslib.system.JanosApplication;
import com.integpg.janoslib.system.UnitConfig;
import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.janoslib.utils.StringUtils;
import com.integpg.system.JANOS;
import com.integpg.system.Watchdog;
import java.io.File;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Hashtable;

public class MqttMain
extends JanosApplication
implements MqttClientListener,
SubscriptionListener,
UnhandledSubscriptionListener,
RegistryListener,
ConfigurationListener {
    private static final Logger UNHANDLED_SUBSCRIPTION_LOGGER = Logger.getLogger(AssemblyInfo.getName() + "_unhandledsubscriptions.log");
    public static final File FLASH_MQTT = new File("/flash/mqtt/");
    public static final String DEVICE_STATUS_TOPIC_PREFIX = "jnior/" + JANOS.getSerialNumber() + "/status/";
    public static final String DEVICE_SET_TOPIC_PREFIX = "jnior/" + JANOS.getSerialNumber() + "/set/";
    public static final QuickDateFormat CONNECTION_DATE_FORMAT = new QuickDateFormat("MM/dd/yyyy HH:mm:ss");
    private static final MqttMain MAIN = new MqttMain();
    private Watchdog _watchdog = null;
    public MqttClient MqttClient = null;
    private String _savedHostname;
    private RelayOutputs _relayOutputs;
    private DigitalInputs _digitalInputs;
    private boolean _successfullyConnected;
    private final Hashtable<String, ExternalModule> _modulesByAddress = new Hashtable();
    private final ArrayList<MqttFourTwentyInputs> _fourTwentyInputs = new ArrayList();
    private final ArrayList<MqttFourTwentyOutputs> _fourTwentyOutputs = new ArrayList();
    private final ArrayList<MqttTenVoltInputs> _tenVoltInputs = new ArrayList();
    private final ArrayList<MqttTenVoltOutputs> _tenVoltOutputs = new ArrayList();
    private final ArrayList<MqttTempProbe> _tempProbes = new ArrayList();
    private final ArrayList<MqttEnvironSensor> _environSensors = new ArrayList();
    private final ArrayList<String> _savedDeviceGroups = new ArrayList();

    public static void main(String[] args) throws InterruptedException {
        MqttMain.exec(MAIN, AssemblyInfo.getInstance(), args);
    }

    public static MqttMain getInstance() {
        return MAIN;
    }

    @Override
    public boolean shouldPreventDuplicateInstance() {
        return true;
    }

    @Override
    public void initWatchdog() {
        this._watchdog = new Watchdog(AssemblyInfo.getName());
        this._watchdog.setAction(0);
        this._watchdog.setDuration(120000);
        this._watchdog.activate();
    }

    @Override
    public void init(String[] args) {
        if (!FLASH_MQTT.exists()) {
            FLASH_MQTT.mkdir();
        }
        Config.addConfigurationUpdatedListener(this);
        Config.load();
        MessagePumpEngine.start();
        this.MqttClient = new MqttClient();
        this.reportConnectionStatus();
        this._digitalInputs = new DigitalInputs(this.MqttClient);
        DigitalInputsIoLogMonitor inputMonitor = new DigitalInputsIoLogMonitor();
        inputMonitor.addIoChannelLogEventListener(this._digitalInputs);
        inputMonitor.start();
        this._relayOutputs = new RelayOutputs(this.MqttClient);
        DigitalOutputsIoLogMonitor outputMonitor = new DigitalOutputsIoLogMonitor();
        outputMonitor.addIoChannelLogEventListener(this._relayOutputs);
        outputMonitor.start();
        RegistryUpdateHandler registryUpdateHandler = new RegistryUpdateHandler();
        registryUpdateHandler.addRegistryListener(this);
        registryUpdateHandler.addRegistryListener(this._digitalInputs);
        registryUpdateHandler.addRegistryListener(this._relayOutputs);
        MessagePumpEngine.addListener(registryUpdateHandler);
        MessagePumpAppHandler mqttAppListener = new MessagePumpAppHandler(1600).addCommandListener("get-status", new GetStatusEventHandler()).addCommandListener("config-updated", new ConfigUpdatedEventHandler()).addCommandListener("connect", new ConnectEventHandler()).addCommandListener("disconnect", new DisconnectEventHandler()).addCommandListener("publish", new PublishEventHandler()).addCommandListener("subscribe", new PublishEventHandler());
        MessagePumpEngine.addListener(mqttAppListener);
        this.MqttClient.addConnectionListener(this);
        this.MqttClient.addSubscriptionListener(this);
        this.MqttClient.setUnhandledSubscriptionListener(this);
        System.out.println("inited");
    }

    @Override
    public boolean subscriptionUpdate(String topic, byte[] data) {
        if (topic.endsWith("set-hostname")) {
            String message = new String(data);
            AppLog.info("setting hostname to " + message);
            JANOS.setRegistryString((String)"IpConfig/Hostname", (String)message);
            return true;
        }
        return false;
    }

    @Override
    public void connectionEstablished(EventObject evt) {
        AppLog.info("Connected to mqtt broker: " + this.MqttClient.getConnectionInfo());
        JANOS.setRegistryString((String)"AppData/MQTT/ConnectionEstablishedTime", (String)CONNECTION_DATE_FORMAT.format(System.currentTimeMillis()));
        this.reportConnectionStatus();
        this._successfullyConnected = true;
    }

    @Override
    public void connectionAknowledged(ConnectionAcknowledgedEventObject evt) {
        System.out.println("connectionAknowledged()");
        ConnAckPacket connAckPacket = evt.getConnAckPacket();
        if (null != connAckPacket) {
            System.out.println("connAckPacket: " + connAckPacket);
            ConnAckReturnCodes returnCode = connAckPacket.getReturnCode();
            AppLog.info("returnCode: " + (Object)((Object)returnCode));
            System.out.println("got here 1");
            this.reportConnectionStatus();
            System.out.println("got here3");
            if (returnCode == ConnAckReturnCodes.CONNECTION_ACCEPTED) {
                System.out.println("got here 2");
                try {
                    String hostname;
                    this.MqttClient.publish(DEVICE_STATUS_TOPIC_PREFIX + "hostname", UnitConfig.getHostname().getBytes(), true);
                    this._savedHostname = hostname = UnitConfig.getHostname();
                    SubscribeOptions subscribeOptions = new SubscribeOptions().addTopic(new SubscribeTopic("jnior/" + UnitConfig.SERIAL_NUMBER + "/set/#", QualityOfService.AT_LEAST_ONCE)).addTopic(new SubscribeTopic("jnior/" + hostname.toLowerCase() + "/set/#", QualityOfService.AT_LEAST_ONCE)).addTopic(new SubscribeTopic("jnior/" + UnitConfig.SERIAL_NUMBER + "/custom/#", QualityOfService.AT_LEAST_ONCE)).addTopic(new SubscribeTopic("jnior/" + hostname.toLowerCase() + "/custom/#", QualityOfService.AT_LEAST_ONCE));
                    this.MqttClient.subscribe(subscribeOptions);
                    this.updateDeviceNameSubscription();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    AppLog.error("error in connection acknowledged", ex);
                }
                this._digitalInputs.reportCurrentStates();
                this._relayOutputs.reportCurrentStates();
            }
        }
    }

    @Override
    public void connectionClosed(EventObject evt) {
        System.out.println("connection closed");
        JANOS.setRegistryString((String)"AppData/MQTT/ConnectionLostTime", (String)CONNECTION_DATE_FORMAT.format(System.currentTimeMillis()));
        this.reportConnectionStatus();
        if (this._successfullyConnected && !this.MqttClient.getClosedGracefully()) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (!MqttMain.this.MqttClient.isConnectionAccepted()) {
                        try {
                            MqttMain.this.MqttClient.connect();
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }, "mqtt-reconnection");
            thread.setDaemon(false);
            thread.start();
        }
    }

    @Override
    public void bytesReceived(BytesReceivedEvent evt) {
    }

    @Override
    public void registryKeyUpdated(String registryKeyName) {
        if ("ipconfig/hostname".equalsIgnoreCase(registryKeyName)) {
            try {
                String hostname = UnitConfig.getHostname();
                AppLog.info("old hostname: " + this._savedHostname);
                UnsubscribeOptions unsubscribeOptions = new UnsubscribeOptions().addTopic("jnior/" + this._savedHostname.toLowerCase() + "/set/#").addTopic("jnior/" + this._savedHostname.toLowerCase() + "/custom/#");
                this.MqttClient.unsubscribe(unsubscribeOptions);
                AppLog.info("new hostname: " + UnitConfig.getHostname());
                SubscribeOptions subscribeOptions = new SubscribeOptions().addTopic(new SubscribeTopic("jnior/" + hostname.toLowerCase() + "/set/#", QualityOfService.AT_LEAST_ONCE)).addTopic(new SubscribeTopic("jnior/" + hostname.toLowerCase() + "/custom/#", QualityOfService.AT_LEAST_ONCE));
                this.MqttClient.subscribe(subscribeOptions);
                this.MqttClient.publish(DEVICE_STATUS_TOPIC_PREFIX + "hostname", hostname.getBytes(), true);
                this._savedHostname = hostname;
            }
            catch (Exception ex) {
                AppLog.error("error handling registry key update for " + registryKeyName + " in MqttMain", ex);
            }
        }
    }

    @Override
    public void connectionAttempt(EventObject evt) {
        String host = Config.getBrokerHost();
        if (null == host || "".equals(host)) {
            return;
        }
        int port = Config.getBrokerPort();
        boolean secure = Config.getEncrypted();
        System.out.println(String.format("connect to %s:%d, secure: %s", host, port, String.valueOf(secure)));
        if (!"".equalsIgnoreCase(host)) {
            String lastWillMessage;
            this.MqttClient.setHost(host).setPort(port).setSecure(secure);
            String lastWillTopic = Config.getLastWillTopic();
            if (null == lastWillTopic || "".equals(lastWillTopic)) {
                lastWillTopic = "jnior/" + JANOS.getSerialNumber() + "/LastWill";
            }
            if (null == (lastWillMessage = Config.getLastWillMessage()) || "".equals(lastWillMessage)) {
                lastWillMessage = "Has disconnected";
            }
            ConnectOptions connectOptions = new ConnectOptions("jr" + JANOS.getSerialNumber());
            connectOptions.setCleanConnection(true).setUsername(Config.getUsername()).setPassword(Config.getPassword()).setKeepAliveSeconds(900).setWillTopic(lastWillTopic).setWillMessage(lastWillMessage).setWillQos(0).setWillRetain(Boolean.FALSE);
            this.MqttClient.setConnectOptions(connectOptions);
        }
    }

    @Override
    public void ConfigurationUpdated() {
        try {
            if (null != this.MqttClient && !Config.getBrokerHost().equalsIgnoreCase(this.MqttClient.getHost())) {
                this.MqttClient.close();
            }
            this.updateDeviceNameSubscription();
        }
        catch (Exception ex) {
            AppLog.error("error in configuration listener", ex);
        }
    }

    @Override
    public void unhandledSubscriptionUpdate(String topic, byte[] data) {
        try {
            UNHANDLED_SUBSCRIPTION_LOGGER.info("topic " + topic + " has not been handled");
            String message = new String(data);
            MqttSystemMessage msg = new MqttSystemMessage("unhandled-topic").put("Topic", topic).put("Payload", message);
            MessagePumpEngine.postMessage(msg.getSystemMsg());
        }
        catch (Exception ex) {
            AppLog.error("error in unhandled subscription handler", ex);
        }
    }

    @Override
    public void run() throws InterruptedException {
        while (true) {
            try {
                this.MqttClient.connect();
                if (this.MqttClient.isConnectionAccepted()) {
                    break;
                }
            }
            catch (Exception ex) {
                AppLog.error("Unable to connect", ex);
            }
            Thread.sleep(10000L);
        }
        while (true) {
            Thread.sleep(10000L);
            this._watchdog.refresh();
            try {
                this.MqttClient.sendPing();
                this.checkForNewDevices();
                for (MqttFourTwentyInputs fourTwentyInputs : this._fourTwentyInputs) {
                    fourTwentyInputs.report();
                }
                for (MqttFourTwentyOutputs fourTwentyOutputs : this._fourTwentyOutputs) {
                    fourTwentyOutputs.report();
                }
                for (MqttTenVoltInputs tenVoltInputs : this._tenVoltInputs) {
                    tenVoltInputs.report();
                }
                for (MqttTenVoltOutputs tenVoltOutputs : this._tenVoltOutputs) {
                    tenVoltOutputs.report();
                }
                for (MqttTempProbe tempProbes : this._tempProbes) {
                    tempProbes.report();
                }
                for (MqttEnvironSensor environSensor : this._environSensors) {
                    environSensor.report();
                }
            }
            catch (Throwable ex) {
                AppLog.error("error in mqtt main loop", ex);
            }
            Thread.sleep(5000L);
        }
    }

    private void updateDeviceNameSubscription() throws Exception {
        try {
            if (null != this.MqttClient) {
                String[] mqttGroups = Config.getDeviceGroups();
                if (0 < this._savedDeviceGroups.size()) {
                    UnsubscribeOptions unsubscribeOptions = new UnsubscribeOptions();
                    for (String savedMqttGroup : this._savedDeviceGroups) {
                        String topicName = "jnior/" + savedMqttGroup.toLowerCase() + "/set/#";
                        AppLog.info("unsubscribe from " + topicName);
                        unsubscribeOptions.addTopic(topicName);
                        topicName = "jnior/" + savedMqttGroup.toLowerCase() + "/custom/#";
                        AppLog.info("unsubscribe from " + topicName);
                        unsubscribeOptions.addTopic(topicName);
                    }
                    this.MqttClient.unsubscribe(unsubscribeOptions);
                }
                if (0 < mqttGroups.length) {
                    SubscribeOptions subscribeOptions = new SubscribeOptions();
                    for (String mqttGroup : mqttGroups) {
                        String topicName = "jnior/" + mqttGroup.toLowerCase() + "/set/#";
                        AppLog.info("subscribe to " + topicName);
                        subscribeOptions.addTopic(new SubscribeTopic(topicName, QualityOfService.AT_LEAST_ONCE));
                        topicName = "jnior/" + mqttGroup.toLowerCase() + "/custom/#";
                        AppLog.info("subscribe to " + topicName);
                        subscribeOptions.addTopic(new SubscribeTopic(topicName, QualityOfService.AT_LEAST_ONCE));
                    }
                    this.MqttClient.subscribe(subscribeOptions);
                }
                this._savedDeviceGroups.clear();
                for (String mqttGroup : mqttGroups) {
                    this._savedDeviceGroups.add(mqttGroup);
                }
            }
        }
        catch (Exception ex) {
            AppLog.error("error in device name subscription handler", ex);
        }
    }

    public void reportConnectionStatus() {
        MqttSystemMessage msg = new MqttSystemMessage("current-status").put("ConnectionStatus", this.MqttClient.isConnectionAccepted()).put("ConnectionInfo", this.MqttClient.getConnectionInfo());
        System.out.println(String.format("ConnectionStatus: %s", msg.getJson().toString()));
        MessagePumpEngine.postMessage(msg.getSystemMsg());
    }

    private void checkForNewDevices() {
        String[] presentDeviceAddressStringArray;
        String presentDeviceAddressStrings = ExternalDeviceOrder.getPresentDevices();
        block6: for (String presentDeviceAddressString : presentDeviceAddressStringArray = StringUtils.split(presentDeviceAddressStrings, ",")) {
            if (this._modulesByAddress.containsKey(presentDeviceAddressString)) continue;
            System.out.println("new module: " + presentDeviceAddressString);
            ExternalModule externalModule = ExternalDeviceFactory.createFromAddressString(presentDeviceAddressString);
            this._modulesByAddress.put(presentDeviceAddressString, externalModule);
            int type = (int)(externalModule.Address & 0xFFL);
            switch (type) {
                case 40: {
                    Type28 tempProbeDevice = (Type28)externalModule;
                    System.out.println(String.format("temp probe: %s", tempProbeDevice.AddressString));
                    this._tempProbes.add(new MqttTempProbe(this.MqttClient, tempProbeDevice));
                    continue block6;
                }
                case 126: {
                    Type7E environSensorDevice = (Type7E)externalModule;
                    System.out.println(String.format("environ sensor: %s", environSensorDevice.AddressString));
                    this._environSensors.add(new MqttEnvironSensor(this.MqttClient, environSensorDevice));
                    continue block6;
                }
                case 253: {
                    TypeFD tenVoltModule = (TypeFD)externalModule;
                    System.out.println(String.format("ten volt module: %s", tenVoltModule.AddressString));
                    this._tenVoltInputs.add(new MqttTenVoltInputs(this.MqttClient, tenVoltModule));
                    this._tenVoltOutputs.add(new MqttTenVoltOutputs(this.MqttClient, tenVoltModule));
                    continue block6;
                }
                case 254: {
                    TypeFE fourTwentyModule = (TypeFE)externalModule;
                    System.out.println(String.format("four twenty module: %s", fourTwentyModule.AddressString));
                    this._fourTwentyInputs.add(new MqttFourTwentyInputs(this.MqttClient, fourTwentyModule));
                    this._fourTwentyOutputs.add(new MqttFourTwentyOutputs(this.MqttClient, fourTwentyModule));
                }
            }
        }
    }
}

