/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.PrintStream;
import java.text.QuickDateFormat;
import java.util.logging.Level;
import java.util.logging.SystemOutLog;

public abstract class Logger {
    protected final QuickDateFormat _quickDateFormat = new QuickDateFormat("MM/dd/yy HH:mm:ss.fff zzz");
    protected PrintStream _printStream;
    protected boolean _finalized = false;

    public static Logger getLogger(String loggerName) {
        return SystemOutLog.getLogger();
    }

    protected void setPrintStream(PrintStream printStream) {
        this._printStream = printStream;
    }

    public PrintStream getPrintStream() {
        return this._printStream;
    }

    public Logger setMaxSizeKB(int maxSizeKB) {
        return this;
    }

    public void log(Level level, String msg, Throwable thrown) {
        if (Level.SEVERE == level) {
            this.error(msg, thrown);
        }
        if (Level.INFO == level) {
            this.info(msg);
        }
    }

    public void vital(String vitalString) {
        this.println(String.format("## %s", vitalString));
    }

    public void info(String infoString) {
        this.println(infoString);
    }

    public void debug(String debugString) {
        this.println(String.format("?? %s", debugString));
    }

    public void warn(String warningString) {
        this.println(String.format(" * %s", warningString));
    }

    public void error(String errorString, Throwable ex) {
        if (null == ex) {
            this.error(errorString);
            return;
        }
        if (null == errorString) {
            this.error(ex);
            return;
        }
        String exceptionMessage = ex.getMessage();
        if (null == exceptionMessage) {
            exceptionMessage = ex.getClass().getName();
        }
        this.println(String.format("** %s: %s", errorString, exceptionMessage));
        ex.printStackTrace(this.getPrintStream());
        System.err.println(String.format("\r\n%s", this._quickDateFormat.format()));
        ex.printStackTrace(System.err);
    }

    public void error(String errorString) {
        if (null != errorString) {
            this.println(String.format("** %s", errorString));
        }
    }

    public void error(Throwable ex) {
        this.println(String.format("** %s", ex.getMessage()));
        ex.printStackTrace(this.getPrintStream());
        System.err.println(String.format("\r\n%s", this._quickDateFormat.format()));
        ex.printStackTrace(System.err);
    }

    public void fatal(String fatalString) {
        this.println(String.format("*** %s", fatalString));
    }

    protected synchronized void println(String s) {
        this._printStream.println(s);
    }

    protected synchronized void print(String s) {
        this._printStream.print(s);
    }

    public synchronized void writeln(String s) {
        this._printStream.print(s);
    }

    public abstract void flush();
}

