/*
 * Decompiled with CFR 0.152.
 */
package com.integ.mqtt.externalmodules;

import com.integ.common.externalmodules.TempProbeDevice;
import com.integ.mqtt.MqttMain;
import com.integ.mqtt.protocol.MqttClient;

public class TempProbe {
    private final MqttClient _mqttClient;
    private final TempProbeDevice _tempProbeDevice;

    public TempProbe(MqttClient mqttClient, TempProbeDevice tempProbeDevice) {
        this._mqttClient = mqttClient;
        this._tempProbeDevice = tempProbeDevice;
    }

    public void report() {
        try {
            if (null != this._mqttClient && null != this._tempProbeDevice && this._tempProbeDevice.isPresent()) {
                System.out.println("temp probe device: " + this._tempProbeDevice.DeviceAddressString);
                this._tempProbeDevice.update();
                int channel = this._tempProbeDevice.DeviceIndex;
                this._mqttClient.publish(MqttMain.DEVICE_STATUS_TOPIC_PREFIX + "tempprobe/" + channel + "/celsius", (String.format("%.2f", this._tempProbeDevice.getCelsius()) + " C").getBytes(), true);
                this._mqttClient.publish(MqttMain.DEVICE_STATUS_TOPIC_PREFIX + "tempprobe/" + channel + "/fahrenheit", (String.format("%.2f", this._tempProbeDevice.getFahrenheit()) + " F").getBytes(), true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

