package com.integ.mqtt;

import com.integpg.system.SystemMsg;
import java.util.Json;

public class MqttSystemMessage {

    private final Json _json = new Json();



    public MqttSystemMessage(String commandString) {
        _json.put("Message", commandString);
    }



    public MqttSystemMessage put(String name, Object value) {
        _json.put(name, value);
        return this;
    }



    public Object getJson() {
        return _json;
    }



    public SystemMsg getSystemMsg() {
        SystemMsg msg = new SystemMsg();
        msg.type = 1600;
        msg.msg = _json.toString().getBytes();
        System.out.println("this.toString(): " + this.toString());
        return msg;
    }

}

