package com.integ.messagepumpengine;

import com.integpg.system.SystemMsg;
import java.util.Hashtable;
import java.util.Json;

public class MessagePumpAppHandler implements MessagePumpListener {

    private final Hashtable<String, MessagePumpAppMessageListener> _appMessageListeners = new Hashtable<>();
    private final int _type;

    private SystemMsg _systemMsg;
    private Json _receivedJson;
    private String _messageString;



    public MessagePumpAppHandler(int type) {
        _type = type;
    }



    public MessagePumpAppHandler addCommandListener(String command, MessagePumpAppMessageListener listener) {
        _appMessageListeners.put(command, listener);
        return this;
    }



    @Override
    public void messageReceived(SystemMsg systemMsg) {
        if (_type == systemMsg.type) {
            _systemMsg = systemMsg;

            new Thread(new Runnable() {
                @Override
                public void run() {
//                    MessagePumpEngine.LOG.info(Thread.currentThread().getName() + " started");
                    long start = System.currentTimeMillis();
                    processMessage();
                    long elapsed = System.currentTimeMillis() - start;
                    MessagePumpEngine.LOG.info("      " + _messageString + " processed in " + elapsed);
                }
            }).start();
        }
    }



    private void processMessage() {
        String contentJsonString = new String(_systemMsg.msg);
        _receivedJson = new Json(contentJsonString);
        _messageString = _receivedJson.getString("Message");
        System.out.println("_messageString: " + _messageString);

        if (_appMessageListeners.containsKey(_messageString)) {
            MessagePumpAppMessageListener listener = _appMessageListeners.get(_messageString);
            if (null != listener) {
                listener.applicationMessageReceived(_receivedJson);
            }
        }

//        if ("get-status".equalsIgnoreCase(_commandString)) {
//            getStatus();
//
//        } else if ("config-updated".equalsIgnoreCase(_commandString)) {
//            Config.load();
//
//        } else if ("connect".equalsIgnoreCase(_commandString)) {
//            MqttMain main = MqttMain.getInstance();
//            if (null != main.MqttClient) {
//                main.MqttClient.connect();
//            }
//
//        } else if ("disconnect".equalsIgnoreCase(_commandString)) {
//            MqttMain main = MqttMain.getInstance();
//            if (null != main.MqttClient) {
//                main.MqttClient.close();
//            }
//
//        }
    }



    private void sendReponse(Json json) {
        // generate a response and post it to the message pump
        SystemMsg responseMsg = new SystemMsg();
        responseMsg.type = _systemMsg.type;
        responseMsg.msg = json.toString().getBytes();
        MessagePumpEngine.postMessage(responseMsg);
    }

//    /**
//     * called to get the current status of the connection
//     */
//    private void getStatus() {
//        MqttMain.getInstance().reportConnectionStatus();
//    }
}

