package com.integ.iolog;

import com.integpg.janoslib.system.UnitConfig;
import com.integpg.system.IoEvent;
import com.integpg.system.JANOS;

public class DigitalInputIoLogMonitor extends IoLogMonitor {

    @Override
    public void alertIoListener(IoLogListener ioLogListener, IoEvent ioEvent) {
        for (int chan = 0; chan < UnitConfig.getInputCount(); chan++) {
            if (1 == ((ioEvent.mask >> chan) & 1)) {
                int state = (ioEvent.states >> chan) & 1;
                System.out.println("@" + QUICK_DATE_FORMAT.format(ioEvent.timestamp)
                        + " channel " + (chan + 1)
                        + " is now " + (1 == state ? "HIGH" : "LOW"));

                DigitalInputEvent digitalInputEvent = new DigitalInputEvent();
                digitalInputEvent.Channel = (chan + 1);
                digitalInputEvent.TransitionTime = ioEvent.timestamp;
                digitalInputEvent.State = (1 == state);
                digitalInputEvent.Counter = JANOS.getInputCounter(chan);
                digitalInputEvent.UsageMeter = JANOS.getUsageMeter(chan);

                ioLogListener.onIoEvent(digitalInputEvent);
            }
        }
    }



    @Override
    protected IoEvent[] getIoEvents() {
        return _iolog.getInputEvents();
    }
}

