/*
 * Decompiled with CFR 0.152.
 */
package com.integ.mqtt;

import com.integ.common.externalmodules.DeviceInfo;
import com.integ.common.externalmodules.PresentDevices;
import com.integ.common.iolog.IoChannelEvent;
import com.integ.common.iolog.IoChannelLogListener;
import com.integ.common.iolog.RelayOutputChannelEvent;
import com.integ.common.logging.AppLog;
import com.integ.common.logging.Logger;
import com.integ.common.logging.RollingFileLog;
import com.integ.common.system.Application;
import com.integ.common.system.UnitConfig;
import com.integ.common.utils.StringUtils;
import com.integ.mqtt.Config;
import com.integ.mqtt.MqttMain;
import com.integ.mqtt.protocol.MqttClient;
import com.integ.mqtt.protocol.SubscriptionListener;
import com.integ.registry.RegistryListener;
import com.integpg.system.JANOS;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RelayOutputs
implements IoChannelLogListener,
SubscriptionListener,
RegistryListener {
    protected static final Logger SUBSCRIPTION_LOG = RollingFileLog.getLogger(Application.getAppName() + "_subscriptionupdates.log");
    private static final Pattern OUTPUTS_PATTERN = Pattern.compile("jnior/([\\d\\w-]+)/set/digital/outputs/([\\d\\w-]+)/.*");
    private static final Pattern STATE_PATTERN = Pattern.compile(".*/state");
    private static final Pattern REGISTRY_OUTPUTS_PATTERN = Pattern.compile("io/outputs/rout(\\d+)/.*", 1);
    private final MqttClient _mqttClient;

    public RelayOutputs(MqttClient mqttClient) {
        this._mqttClient = mqttClient;
        this._mqttClient.addSubscriptionListener(this);
    }

    public void reportCurrentStates() {
        int outputCount = UnitConfig.getOutputCount();
        int outputStates = JANOS.getOutputStates();
        for (int i = 1; i <= outputCount; ++i) {
            try {
                boolean state = 1 == (outputStates >> i - 1 & 1);
                this._mqttClient.publish(MqttMain.DEVICE_STATUS_TOPIC_PREFIX + "digital/outputs/" + i + "/state", String.valueOf(state).getBytes(), true);
                long usageMeter = JANOS.getUsageMeter((int)(i - 1 + UnitConfig.getInputCount()));
                this._mqttClient.publish(MqttMain.DEVICE_STATUS_TOPIC_PREFIX + "digital/outputs/" + i + "/usagemeter", String.valueOf((double)usageMeter / 3600000.0).getBytes(), true);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        int allowedModuleCount = 4 - outputCount / 4;
        System.out.println("allowed module count: " + allowedModuleCount);
        for (int moduleIndex = 0; moduleIndex < allowedModuleCount; ++moduleIndex) {
            long deviceAddress = DeviceInfo.getModuleAddressAtIndex("TypeFB", moduleIndex + 1);
            System.out.println("deviceAddress: " + deviceAddress);
            if (-1L == deviceAddress) continue;
            String deviceAddressString = "0000000000000000" + Long.toHexString(deviceAddress);
            deviceAddressString = deviceAddressString.substring(deviceAddressString.length() - 16);
            System.out.println("deviceAddressString: " + deviceAddressString);
            boolean isPresent = PresentDevices.isPresent(deviceAddressString);
            System.out.println("is " + deviceAddressString + " present: " + isPresent);
            if (!isPresent) continue;
            int channelOffset = outputCount + moduleIndex * 4;
            for (int i = channelOffset + 1; i <= channelOffset + 4; ++i) {
                System.out.println("i: " + i);
                try {
                    boolean state = 1 == (outputStates >> i - 1 & 1);
                    this._mqttClient.publish(MqttMain.DEVICE_STATUS_TOPIC_PREFIX + "digital/outputs/" + i + "/state", String.valueOf(state).getBytes(), true);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    @Override
    public void onIoChannelEvent(IoChannelEvent ioEvent) {
        try {
            System.out.println("output changed");
            RelayOutputChannelEvent digitalOutputEvent = (RelayOutputChannelEvent)ioEvent;
            this._mqttClient.publish(MqttMain.DEVICE_STATUS_TOPIC_PREFIX + "digital/outputs/" + digitalOutputEvent.Channel + "/state", String.valueOf(digitalOutputEvent.State).getBytes(), true);
            this._mqttClient.publish(MqttMain.DEVICE_STATUS_TOPIC_PREFIX + "digital/outputs/" + digitalOutputEvent.Channel + "/usagemeter", String.valueOf((double)digitalOutputEvent.UsageMeter / 3600000.0).getBytes(), true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static boolean isNumeric(String s) {
        boolean isNumeric = true;
        for (int j = 0; isNumeric && j < s.length(); isNumeric &= Character.isDigit(s.charAt(j)), ++j) {
        }
        return isNumeric;
    }

    @Override
    public boolean subscriptionUpdate(String topic, byte[] data) {
        String topicValue = new String(data);
        SUBSCRIPTION_LOG.info(topic + ": " + topicValue);
        Matcher matcher = OUTPUTS_PATTERN.matcher(topic);
        boolean found = matcher.find();
        if (found) {
            int channelMask = 0;
            String outputString = matcher.group(2);
            if (RelayOutputs.isNumeric(outputString)) {
                int channel = Integer.parseInt(outputString);
                channelMask = 1 << channel - 1;
            } else {
                channelMask = Config.getOutputMask(outputString);
            }
            System.out.println(String.format("channelMask: 0x%d", channelMask));
            int statesMask = channelMask;
            matcher = STATE_PATTERN.matcher(topic);
            found = matcher.find();
            if (found) {
                boolean newState;
                String[] parts = StringUtils.split(topicValue, " ");
                System.out.println("parts.length: " + parts.length);
                String newStateString = parts[0];
                boolean bl = newState = null != newStateString && ("true".equalsIgnoreCase(newStateString) || "high".equalsIgnoreCase(newStateString) || "on".equalsIgnoreCase(newStateString) || "set".equalsIgnoreCase(newStateString) || "1".equalsIgnoreCase(newStateString));
                if (!newState) {
                    statesMask ^= 0xFFF;
                }
                System.out.println(String.format("set channelMask to 0x%d", statesMask &= channelMask));
                if (1 < parts.length) {
                    try {
                        double duration = Double.valueOf(parts[1].trim());
                        JANOS.setOutputPulsed((int)statesMask, (int)channelMask, (int)((int)(duration * 1000.0)));
                        return true;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                } else {
                    try {
                        System.out.println(String.format("set 0x%d to 0x%d", channelMask, statesMask));
                        JANOS.setOutputStates((int)statesMask, (int)channelMask);
                        return true;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        return false;
    }

    @Override
    public void registryKeyUpdated(String registryKeyName) {
        block5: {
            try {
                Matcher matcher = REGISTRY_OUTPUTS_PATTERN.matcher(registryKeyName);
                boolean found = matcher.find();
                if (!found) break block5;
                try {
                    int channel = Integer.parseInt(matcher.group(1));
                    String regValue = JANOS.getRegistryString((String)registryKeyName, (String)"");
                    if (registryKeyName.endsWith("$HourMeter")) {
                        this._mqttClient.publish(MqttMain.DEVICE_STATUS_TOPIC_PREFIX + "digital/outputs/" + channel + "/usagemeter", regValue.getBytes());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            catch (Exception ex) {
                AppLog.error("error handling registry key update for " + registryKeyName + " in digital outputs", ex);
            }
        }
    }
}

