// i would create a class for the configuration. This class will be responsible for reading the
//  config file from and writing the config file to the web socket connection.
function JniorConfigStorage(websocket, configFileLocation) {
    var CONFIG_FILE_NAME = configFileLocation;
    var WebSocket = websocket;

    var _this = this;
    _this.Config = {};
    // we save a copy for comparison.  This helps us determine if there have been any changes.
    _this.SavedConfig = {};


    _this.readConfig = function (callback) {
        WebSocket.readFile(CONFIG_FILE_NAME, function (response) {
            console.log('readFile status for ' + response.File + ': ' + response.Status);
            if ('Fail' !== response.Status) {
                var fileContents = Base64.decode(response.Data);
                _this.Config = JSON.parse(fileContents);
                _this.SavedConfig = JSON.parse(JSON.stringify(_this.Config));
            }
            if (callback) callback(response.Status, _this.Config);
        });
    };


    _this.saveConfig = function (callback) {
        // make sure the config directory exists
        var configFileDirectory = CONFIG_FILE_NAME.substring(0, CONFIG_FILE_NAME.lastIndexOf('/'));
        WebSocket.mkDir(configFileDirectory, function (result) {
            console.log('mkDir result for ' + result.Folder + ': ' + result.Status);

            if ('Succeed' === result.Result) {
                // the stringify with '2' specifies that it is prettified with 2 spaces for the indentation
                var jsonString = JSON.stringify(_this.Config, null, 2);
                WebSocket.writeFile(CONFIG_FILE_NAME, jsonString, function (response) {
                    console.log('writeFile status for ' + response.File + ': ' + response.Status);
                    if ('Fail' !== response.Status) {
                        _this.SavedConfig = JSON.parse(JSON.stringify(_this.Config));
                    }
                    if (callback) callback(response.Status);
                });
            }
        });
    };
}
