/*
 * Decompiled with CFR 0.152.
 */
package com.integ.mqtt.externalmodules;

import com.integ.common.externalmodules.TenVoltModule;
import com.integ.common.logging.AppLog;
import com.integ.mqtt.MqttMain;
import com.integ.mqtt.protocol.MqttClient;
import com.integ.mqtt.protocol.SubscriptionListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MqttTenVoltOutputs
implements SubscriptionListener {
    private static final Pattern OUTPUTS_PATTERN = Pattern.compile("jnior/([\\d\\w-]+)/set/tenvolt/outputs/([\\d\\w-]+)/.*");
    private static final Pattern PERCENTAGE_PATTERN = Pattern.compile(".*/percentage");
    private final MqttClient _mqttClient;
    private final TenVoltModule _tenVoltModule;

    public MqttTenVoltOutputs(MqttClient mqttClient, TenVoltModule tenVoltModule) {
        this._mqttClient = mqttClient;
        this._mqttClient.addSubscriptionListener(this);
        this._tenVoltModule = tenVoltModule;
    }

    public void report() {
        try {
            if (null != this._mqttClient && null != this._tenVoltModule && this._tenVoltModule.isPresent()) {
                this._tenVoltModule.update();
                int index = this._tenVoltModule.DeviceIndex - 1;
                for (int channel = 1; channel <= 2; ++channel) {
                    this._mqttClient.publish(MqttMain.DEVICE_STATUS_TOPIC_PREFIX + "tenvolt/outputs/" + (index * 2 + channel) + "/raw", String.valueOf(this._tenVoltModule.getRawOut(channel - 1)).getBytes(), true);
                    this._mqttClient.publish(MqttMain.DEVICE_STATUS_TOPIC_PREFIX + "tenvolt/outputs/" + (index * 2 + channel) + "/percentage", String.valueOf(this._tenVoltModule.getPercentageOut(channel - 1)).getBytes(), true);
                    this._mqttClient.publish(MqttMain.DEVICE_STATUS_TOPIC_PREFIX + "tenvolt/outputs/" + (index * 2 + channel) + "/scaled", String.format("%.2f %s", this._tenVoltModule.getScaledOutput(channel - 1), this._tenVoltModule.getOutputUnits(channel)).getBytes(), true);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean subscriptionUpdate(String topic, byte[] data) {
        String topicValue = new String(data);
        System.out.println("match " + OUTPUTS_PATTERN.pattern() + ", " + topic);
        Matcher matcher = OUTPUTS_PATTERN.matcher(topic);
        boolean found = matcher.find();
        System.out.println(OUTPUTS_PATTERN.pattern() + " matched: " + found);
        if (found) {
            String outputString = matcher.group(2);
            if (!MqttTenVoltOutputs.isNumeric(outputString)) {
                throw new RuntimeException("error getting channel from " + topic);
            }
            int channel = Integer.parseInt(outputString);
            System.out.println(String.format("channel: 0x%d", channel));
            matcher = PERCENTAGE_PATTERN.matcher(topic);
            found = matcher.find();
            System.out.println(PERCENTAGE_PATTERN.pattern() + " matched: " + found);
            if (found) {
                try {
                    double percentage = Double.valueOf(topicValue);
                    if (0.0 > percentage || 100.0 < percentage) {
                        throw new RuntimeException("Percentage out of range for " + topic + ": " + percentage);
                    }
                    this._tenVoltModule.setPercentageOutput(channel - 1, percentage);
                    this._tenVoltModule.commit();
                    this.report();
                }
                catch (Exception ex) {
                    AppLog.error("error converting " + topicValue + " to a percentage", ex);
                }
            }
        }
        return false;
    }

    private static boolean isNumeric(String s) {
        boolean isNumeric = true;
        for (int j = 0; isNumeric && j < s.length(); isNumeric &= Character.isDigit(s.charAt(j)), ++j) {
        }
        return isNumeric;
    }
}

