/*
 * Decompiled with CFR 0.152.
 */
package com.integ.common.system;

import com.integ.common.CommonLib;
import com.integ.common.logging.AppLog;
import com.integ.common.system.ApplicationWatchdog;
import com.integ.common.system.AssemblyBase;
import com.integ.common.system.ReleaseInfo;
import com.integ.common.system.UnitConfig;
import com.integ.common.utils.FileUtils;
import com.integpg.system.JANOS;
import java.io.File;
import java.io.IOException;
import java.text.QuickDateFormat;
import java.util.ArrayList;
import java.util.Json;

public class Application {
    private static final CommonLib COMMON_LIB = new CommonLib();
    private static AssemblyBase _assemblyBase;
    private static String _instanceName;
    private static String _registryRoot;
    private static boolean _isBackground;

    public static void init(AssemblyBase assemblyInfo) {
        Application.init(assemblyInfo, null);
    }

    public static void init(AssemblyBase assemblyInfo, String instanceName) {
        _assemblyBase = assemblyInfo;
        _instanceName = instanceName;
        _registryRoot = "AppData/" + _assemblyBase.getName() + "/";
        if (null != _instanceName) {
            _registryRoot = _registryRoot + _instanceName + "/";
        }
        JANOS.setRegistryString((String)(_registryRoot + "$Version"), (String)_assemblyBase.getVersion());
        JANOS.setRegistryString((String)(_registryRoot + "$BuildTime"), (String)_assemblyBase.getBuildTime());
        JANOS.setRegistryString((String)(_registryRoot + "$CommonLibraryVersion"), (String)COMMON_LIB.getVersion());
        JANOS.setRegistryString((String)(_registryRoot + "$CommonLibraryBuildTime"), (String)COMMON_LIB.getBuildTime());
        _isBackground = Application.setIsBackground();
        Application.logBanner();
        try {
            Json releaseNotesJson = Application.getReleaseNotesJson(assemblyInfo);
            if (null != releaseNotesJson) {
                FileUtils.writeAllBytes(Application.getAppName().toLowerCase() + "_releasenotes.json", releaseNotesJson.toString().getBytes());
            }
        }
        catch (Exception ex) {
            AppLog.warn("error writing release notes");
            ex.printStackTrace();
        }
    }

    public static String getAppName() {
        return _assemblyBase.getName();
    }

    public static String getAppInstanceName() {
        String name = _assemblyBase.getName();
        if (null != _instanceName) {
            name = name + "-" + _instanceName;
        }
        return name;
    }

    public static String getAppVersion() {
        return _assemblyBase.getVersion();
    }

    public static String getInstanceName() {
        return _instanceName;
    }

    public static String getUuid() {
        return _assemblyBase.getUUID();
    }

    public static String getRegistryRoot() {
        return _registryRoot;
    }

    public static boolean isBackground() {
        return _isBackground;
    }

    private static boolean setIsBackground() {
        int thisProcessId = JANOS.getProcessID();
        String thisProcessName = JANOS.getProcessName((int)thisProcessId);
        boolean isBackground = thisProcessName.startsWith("Run");
        if (!isBackground) {
            int lastSlashPos = thisProcessName.indexOf("/", 8);
            String thisProcessParent = thisProcessName.substring(0, lastSlashPos);
            if (!thisProcessParent.startsWith("Command")) {
                isBackground = true;
            } else {
                int[] processIds = JANOS.getProcessIDs();
                for (int i = 0; i < processIds.length && !isBackground; ++i) {
                    String processName;
                    int processId = processIds[i];
                    if (thisProcessId == processId || (processName = JANOS.getProcessName((int)processId)).length() < lastSlashPos) continue;
                    isBackground = thisProcessParent.equals(processName);
                }
            }
        }
        return isBackground;
    }

    public static String printReleaseNotes(AssemblyBase assemblyBase) {
        StringBuilder sb = new StringBuilder();
        sb.append("Version: " + assemblyBase.getVersion() + "\r\n\r\n");
        ReleaseInfo[] releaseNotes = assemblyBase.getReleaseNotes();
        if (null != releaseNotes) {
            for (ReleaseInfo releaseInfo : releaseNotes) {
                String releaseInfoString = releaseInfo.getVersion() + "          ";
                releaseInfoString = releaseInfoString.substring(0, 10) + releaseInfo.getDate();
                sb.append(releaseInfoString + "\r\n");
                for (String note : releaseInfo.getReleaseNotes()) {
                    int maxLineLength = 90;
                    int pos = 0;
                    int endPos = 0;
                    while (pos < note.length()) {
                        if (note.length() < (endPos += maxLineLength)) {
                            endPos = note.length();
                        } else {
                            int lastSpacePos = note.lastIndexOf(" ", endPos);
                            if (pos < lastSpacePos) {
                                endPos = lastSpacePos + 1;
                            }
                        }
                        if (0 == pos) {
                            sb.append("        * ");
                        } else {
                            sb.append("          ");
                        }
                        sb.append(note.substring(pos, endPos) + "\r\n");
                        pos = endPos;
                    }
                }
                sb.append("\r\n");
            }
        }
        return sb.toString();
    }

    private static Json getReleaseNotesJson(AssemblyBase assemblyBase) {
        if (null != assemblyBase.getReleaseNotes()) {
            Json json = new Json();
            json.put("CurrentVersion", (Object)assemblyBase.getVersion());
            json.put("BuildTime", (Object)assemblyBase.getBuildTime());
            ArrayList<Json> releaseInfoJsonArray = new ArrayList<Json>();
            System.out.println("release notes: " + assemblyBase.getReleaseNotes());
            for (ReleaseInfo releaseInfo : assemblyBase.getReleaseNotes()) {
                Json releaseInfoJson = new Json();
                releaseInfoJson.put("Version", (Object)releaseInfo.getVersion());
                releaseInfoJson.put("Date", (Object)releaseInfo.getDate());
                releaseInfoJson.put("Notes", (Object)((String[])releaseInfo.getReleaseNotes().toArray()));
                releaseInfoJsonArray.add(releaseInfoJson);
            }
            json.put("ReleaseNotes", (Object)((Json[])releaseInfoJsonArray.toArray()));
            return json;
        }
        return null;
    }

    private static void logBanner() {
        String versionString = Application.getAppInstanceName() + " v" + _assemblyBase.getVersion();
        boolean isForeground = !_isBackground;
        AppLog.vital(versionString);
        if (!_assemblyBase.getBuildTime().equals("")) {
            AppLog.vital(" build-time: " + _assemblyBase.getBuildTime());
        }
        AppLog.vital(" using INTEG Common Library v" + COMMON_LIB.getVersion());
        AppLog.vital(" running on JANOS " + JANOS.getVersion());
        AppLog.vital(String.format(" run as process %d%s", JANOS.getProcessID(), isForeground ? " in FOREGROUND" : ""));
        AppLog.vital("Serial Number: " + UnitConfig.SERIAL_NUMBER + ", Model: " + UnitConfig.MODEL);
        JANOS.syslog((String)String.format("-- %s%s built %s", versionString, isForeground ? " (foreground)" : "", _assemblyBase.getBuildTime()));
        Application.updateBootLog();
    }

    private static void updateBootLog() {
        try {
            QuickDateFormat quickDateFormat = new QuickDateFormat("MM/dd/yy HH:mm:ss zzz");
            String entry = String.format("%s, %s v%s (built %s) using INTEG Common Library v%s (built %s) running on JANOS %s\r\n", quickDateFormat.format(System.currentTimeMillis()), Application.getAppInstanceName(), _assemblyBase.getVersion(), _assemblyBase.getBuildTime(), COMMON_LIB.getVersion(), COMMON_LIB.getBuildTime(), JANOS.getVersion());
            File bootlogFile = new File(Application.getAppName().toLowerCase() + "_boot.log");
            if (16384L < bootlogFile.length() + (long)entry.length()) {
                File bakFile = new File(bootlogFile.getPath() + ".bak");
                if (bakFile.exists()) {
                    bakFile.delete();
                }
                bootlogFile.renameTo(bakFile);
            }
            FileUtils.appendAllBytes(bootlogFile.getPath(), entry.toString().getBytes());
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    public static void enableApplicationWatchdog(int watchdogAction) {
        ApplicationWatchdog applicationWatchdog = new ApplicationWatchdog(watchdogAction);
        applicationWatchdog.start();
    }

    public static void sleepForever() {
        try {
            System.out.println("sleep forever");
            Thread.sleep(Integer.MAX_VALUE);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public static void exit(int status) {
        System.exit(status);
    }

    static {
        _instanceName = null;
        _registryRoot = "";
        _isBackground = false;
    }
}

