/*
 * Decompiled with CFR 0.152.
 */
package com.integ.mqtt.externalmodules;

import com.integ.common.externalmodules.FourTwentyModule;
import com.integ.mqtt.MqttMain;
import com.integ.mqtt.protocol.MqttClient;

public class FourTwentyInputs {
    private final MqttClient _mqttClient;
    private final FourTwentyModule _fourTwentyModule;

    public FourTwentyInputs(MqttClient mqttClient, FourTwentyModule fourTwentyModule) {
        this._mqttClient = mqttClient;
        this._fourTwentyModule = fourTwentyModule;
    }

    public void report() {
        try {
            if (null != this._mqttClient && null != this._fourTwentyModule && this._fourTwentyModule.isPresent()) {
                this._fourTwentyModule.update();
                System.out.println(String.format("typeIndex: %d", this._fourTwentyModule.DeviceIndex));
                int index = this._fourTwentyModule.DeviceIndex - 1;
                for (int channel = 1; channel <= 4; ++channel) {
                    this._mqttClient.publish(MqttMain.DEVICE_STATUS_TOPIC_PREFIX + "fourtwenty/inputs/" + (index * 4 + channel) + "/raw", String.valueOf(this._fourTwentyModule.getRawIn(channel - 1)).getBytes(), true);
                    this._mqttClient.publish(MqttMain.DEVICE_STATUS_TOPIC_PREFIX + "fourtwenty/inputs/" + (index * 4 + channel) + "/percentage", String.valueOf(this._fourTwentyModule.getPercentageIn(channel - 1)).getBytes(), true);
                    this._mqttClient.publish(MqttMain.DEVICE_STATUS_TOPIC_PREFIX + "fourtwenty/inputs/" + (index * 4 + channel) + "/scaled", String.format("%.2f %s", this._fourTwentyModule.getScaledInput(channel - 1), this._fourTwentyModule.getInputUnits(channel)).getBytes(), true);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

