package com.integ.registry;

import com.integ.messagepumpengine.MessagePumpListener;
import com.integpg.janoslib.messaging.MessageLoopTypes;
import com.integpg.system.SystemMsg;
import java.util.ArrayList;

public class RegistryUpdateHandler implements MessagePumpListener {

    private final ArrayList<RegistryListener> _registryListeners = new ArrayList<>();



    public void addRegistryListener(RegistryListener listener) {
        _registryListeners.add(listener);
    }



    @Override
    public void messageReceived(SystemMsg systemMsg) throws Throwable {
        try {
            // we only care about registry mesages
            if (systemMsg.type == MessageLoopTypes.SM_REGUPDATE) {
                handleMessage(systemMsg);
            }
        } catch (Exception ex) {
            throw new Exception("Error handling registry update").initCause(ex);
        }
    }



    private void handleMessage(SystemMsg systemMsg) {
        // get the registry key that was updated from the payload of the system message
        String registryKeyName = new String(systemMsg.msg);
        System.out.println("registry key has been updated: " + registryKeyName);

        for (RegistryListener registryListener : _registryListeners) {
            registryListener.registryKeyUpdated(registryKeyName);
        }
    }

}

