package com.integ.mqtt.messagehandlers;

import com.integpg.janoslib.io.AppLog;
import java.util.Json;
import com.integ.messagepumpengine.MessagePumpAppMessageListener;
import com.integ.mqtt.MqttMain;

public class PublishEventHandler implements MessagePumpAppMessageListener {

    @Override
    public void applicationMessageReceived(Json commandJson) {
        String topicString = null;
        String payloadString = null;

        try {
            // get the topic
            topicString = commandJson.getString("Topic");
            if (null == topicString || "".equals(topicString))
                throw new IllegalArgumentException("MQTT Topic must not be null in MQTT Message");
            payloadString = commandJson.getString("Payload");
            if (null == payloadString || "".equals(payloadString))
                throw new IllegalArgumentException("MQTT Payload must not be null in MQTT Message");

            MqttMain.getInstance().MqttClient.publish(topicString, payloadString.getBytes());
        } catch (Exception ex) {
            AppLog.error("error publishing to " + topicString, ex);
        }
    }

}

