package com.integ.mqtt;

import com.integpg.janoslib.externalio.TypeFE;
import com.integpg.janoslib.mqtt.MqttClient;

public class FourTwentyInputs {

    private final MqttClient _mqttClient;
    private final TypeFE _typeFE;



    public FourTwentyInputs(MqttClient mqttClient, TypeFE typeFE) {
        _mqttClient = mqttClient;
        _typeFE = typeFE;
    }



    public void report() {
        try {
            if (null != _mqttClient&& null != _typeFE) {
                _typeFE.read();
                System.out.println(String.format("typeIndex: %d", _typeFE.TypeIndex));
                int index = _typeFE.TypeIndex - 1;

                for (int channel = 1; channel <= 4; channel++) {
                    _mqttClient.publish(
                            MqttMain.DEVICE_STATUS_TOPIC_PREFIX + "fourtwenty/inputs/" + (index * 4 + channel) + "/raw",
                            String.valueOf(_typeFE.RawIn[channel - 1]).getBytes(), true);
                    _mqttClient.publish(
                            MqttMain.DEVICE_STATUS_TOPIC_PREFIX + "fourtwenty/inputs/" + (index * 4 + channel) + "/scaled",
                            String.format("%.2f %s", _typeFE.getScaledInput(channel), _typeFE.getInputUnits(channel)).getBytes(), true);
                }

            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

}

