/*
 * Decompiled with CFR 0.152.
 */
package com.integ.mqtt.messagehandlers;

import com.integ.mqtt.MqttMain;
import com.integ.mqtt.protocol.QualityOfService;
import com.integ.mqtt.protocol.SubscribeOptions;
import com.integ.mqtt.protocol.SubscribeTopic;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.messagepump.MessagePumpAppMessageListener;
import com.integpg.janoslib.utils.StringUtils;
import java.util.Json;

public class SubscribeEventHandler
implements MessagePumpAppMessageListener {
    @Override
    public void applicationMessageReceived(Json commandJson) {
        String[] topicsArray = null;
        try {
            SubscribeOptions subscribeOptions = new SubscribeOptions();
            topicsArray = (String[])commandJson.get("Topics");
            if (null == topicsArray || 0 == topicsArray.length) {
                throw new IllegalArgumentException("MQTT Topic must not be null in MQTT Message");
            }
            String topicsArrayString = String.format("[%s]", StringUtils.join(topicsArray, ","));
            System.out.println("subscribe to " + topicsArrayString);
            for (String topicString : topicsArray) {
                SubscribeTopic subscribeTopic = new SubscribeTopic(topicString, QualityOfService.AT_LEAST_ONCE);
                subscribeOptions.addTopic(subscribeTopic);
            }
            MqttMain.getInstance().MqttClient.subscribe(subscribeOptions);
        }
        catch (Exception ex) {
            String topicsArrayString = String.format("[%s]", StringUtils.join(topicsArray, ","));
            AppLog.error("error subscribing to " + topicsArrayString, ex);
        }
    }
}

