/*
 * Decompiled with CFR 0.152.
 */
package com.integ.mqtt.externalmodules;

import com.integ.mqtt.Config;
import com.integ.mqtt.MqttMain;
import com.integ.mqtt.protocol.MqttClient;
import com.integpg.janoslib.externalio.Type7E;
import java.util.Json;

public class MqttEnvironSensor {
    private final MqttClient _mqttClient;
    private final Type7E _environSensorDevice;
    private final Json _json = new Json();
    private final String _environTopicPrefix;
    private final String _celsiusTopicString;
    private final String _fahrenheitTopicString;
    private final String _humidityTopicString;

    public MqttEnvironSensor(MqttClient mqttClient, Type7E environSensorDevice) {
        this._mqttClient = mqttClient;
        this._environSensorDevice = environSensorDevice;
        int index = this._environSensorDevice.TypeIndex - 1;
        int channel = index + 1;
        this._environTopicPrefix = String.format("%senviron/%d", MqttMain.DEVICE_STATUS_TOPIC_PREFIX, channel);
        this._celsiusTopicString = String.format("%s/celsius", this._environTopicPrefix, channel);
        this._fahrenheitTopicString = String.format("%s/fahrenheit", this._environTopicPrefix, channel);
        this._humidityTopicString = String.format("%s/humidity", this._environTopicPrefix, channel);
    }

    public void report() {
        try {
            if (null != this._mqttClient && null != this._environSensorDevice && this._environSensorDevice.isPresent()) {
                System.out.println("environ sensor device: " + this._environSensorDevice.AddressString);
                this._environSensorDevice.read();
                int channel = this._environSensorDevice.TypeIndex;
                int payloadFormat = Config.getPayloadFormat();
                if (1 == payloadFormat || 3 == payloadFormat) {
                    this._mqttClient.publish(this._celsiusTopicString, (String.format("%.2f", this._environSensorDevice.getTempC()) + " C").getBytes(), true);
                    this._mqttClient.publish(this._fahrenheitTopicString, (String.format("%.2f", this._environSensorDevice.getTempF()) + " F").getBytes(), true);
                    this._mqttClient.publish(this._humidityTopicString, (String.format("%.2f", this._environSensorDevice.getHumidity()) + " %").getBytes(), true);
                }
                if (2 == payloadFormat || 3 == payloadFormat) {
                    this.updateJson(channel);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void updateJson(int channel) {
        try {
            this._json.put("Celsius", (Object)(String.format("%.2f", this._environSensorDevice.getTempC()) + " C").getBytes());
            this._json.put("Fahrenheit", (Object)(String.format("%.2f", this._environSensorDevice.getTempF()) + " F").getBytes());
            this._json.put("Humidity", (Object)(String.format("%.2f", this._environSensorDevice.getHumidity()) + " %").getBytes());
            this._mqttClient.publish(this._environTopicPrefix, this._json.toString().getBytes(), true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

