/*
 * Decompiled with CFR 0.152.
 */
package com.integ.mqtt.externalmodules;

import com.integ.janoslib.externalmodules.TempProbe;
import com.integ.mqtt.MqttMain;
import com.integ.mqtt.protocol.MqttClient;
import com.integpg.janoslib.system.UnitConfig;
import com.integpg.system.JANOS;
import java.util.Json;

public class MqttTempProbe {
    private final MqttClient _mqttClient;
    private final TempProbe _tempProbeDevice;
    private final Json _json = new Json();

    public MqttTempProbe(MqttClient mqttClient, TempProbe tempProbeDevice) {
        this._mqttClient = mqttClient;
        this._tempProbeDevice = tempProbeDevice;
    }

    public void report() {
        try {
            if (null != this._mqttClient && null != this._tempProbeDevice && this._tempProbeDevice.isPresent()) {
                System.out.println("temp probe device: " + this._tempProbeDevice.DeviceAddressString);
                this._tempProbeDevice.update();
                int channel = this._tempProbeDevice.DeviceIndex;
                this.updateJsonForOutput(channel);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void updateJsonForOutput(int channel) {
        try {
            int channelIndex = channel - 1;
            int outputStates = JANOS.getOutputStates();
            boolean state = 1 == (outputStates >> channelIndex & 1);
            this._json.put("Celsius", (Object)String.valueOf(state));
            long usageMeter = JANOS.getUsageMeter((int)(channelIndex + UnitConfig.getInputCount()));
            this._json.put("Fahrenheit", (Object)String.valueOf((double)usageMeter / 3600000.0));
            String tempProbeTopicPrefix = String.format("%stempprobe/%d", MqttMain.DEVICE_STATUS_TOPIC_PREFIX, channel);
            this._mqttClient.publish(tempProbeTopicPrefix, this._json.toString().getBytes(), true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

